#!/bin/bash

# BGP Status monitoring script for MCC container
MCC_CONTAINER_NAME="MCC"

# Get BGP protocol name (case-insensitive)
BGP_PROTO=$(docker exec $MCC_CONTAINER_NAME birdc show protocols 2>/dev/null | grep -i bgp | awk '{print $1}' | head -1)

if [ -z "$BGP_PROTO" ]; then
    echo "bgp_status,host=mcc-node state=\"down\",state_numeric=0i"
    echo "bgp_routes,host=mcc-node learned=0i"
    exit 0
fi

# Get BGP state from protocols list
BGP_INFO=$(docker exec $MCC_CONTAINER_NAME birdc show protocols 2>/dev/null | grep -i "$BGP_PROTO" | awk '{print $6}')

# Get route counts
ROUTE_OUTPUT=$(docker exec $MCC_CONTAINER_NAME birdc show route protocol $BGP_PROTO count 2>/dev/null)
ROUTES_LEARNED=$(echo "$ROUTE_OUTPUT" | grep -oP '^\d+' | head -1)
TOTAL_ROUTES=$(echo "$ROUTE_OUTPUT" | grep -oP 'for \K\d+' | head -1)

# Get detailed neighbor info
NEIGHBOR_IP=$(docker exec $MCC_CONTAINER_NAME birdc show protocols all $BGP_PROTO 2>/dev/null | grep "Neighbor address" | awk '{print $3}')
NEIGHBOR_AS=$(docker exec $MCC_CONTAINER_NAME birdc show protocols all $BGP_PROTO 2>/dev/null | grep "Neighbor AS" | awk '{print $3}')

# Default values
BGP_STATE=${BGP_INFO:-"down"}
ROUTES_LEARNED=${ROUTES_LEARNED:-0}
TOTAL_ROUTES=${TOTAL_ROUTES:-0}
NEIGHBOR_AS=${NEIGHBOR_AS:-0}

# Convert BGP status to numeric
if [ "$BGP_STATE" = "Established" ]; then
    STATUS_NUM=1
else
    STATUS_NUM=0
fi

# Output in InfluxDB line protocol
echo "bgp_status,host=mcc-node,protocol=$BGP_PROTO state=\"$BGP_STATE\",state_numeric=${STATUS_NUM}i"
echo "bgp_routes,host=mcc-node,protocol=$BGP_PROTO learned=${ROUTES_LEARNED}i,total=${TOTAL_ROUTES}i"

if [ -n "$NEIGHBOR_IP" ]; then
    echo "bgp_neighbor,host=mcc-node,neighbor=$NEIGHBOR_IP,protocol=$BGP_PROTO as_number=${NEIGHBOR_AS}i,prefixes=${ROUTES_LEARNED}i"
fi
