#!/bin/bash

# BGP Prefix list script for MCC container
MCC_CONTAINER_NAME="MCC"

# Get BGP protocol name
BGP_PROTO=$(docker exec $MCC_CONTAINER_NAME birdc show protocols 2>/dev/null | grep -i bgp | awk '{print $1}' | head -1)

if [ -z "$BGP_PROTO" ]; then
    exit 0
fi

# Get all prefixes learned from BGP peer
docker exec $MCC_CONTAINER_NAME birdc show route protocol $BGP_PROTO 2>/dev/null | \
    grep -oP '^\d+\.\d+\.\d+\.\d+/\d+' | \
    while read prefix; do
        echo "bgp_prefix,host=mcc-node,protocol=$BGP_PROTO,prefix=$prefix count=1i"
    done
