# LanCache Domain Collector Service

Background service that passively monitors DNS queries and collects domain names for potential caching.

## Files

- `lancache-domain-collector.sh` - Main service script
- `lancache-domain-collector.service` - Systemd service file
- `README.md` - This file

## Installation

The service is automatically installed by `lancache-install.sh` during system setup.

### Installation Location

- **Script**: `/usr/local/bin/lancache-domain-collector`
- **Service**: `/etc/systemd/system/lancache-domain-collector.service`
- **Database**: `/var/lib/lancache/collected-domains.txt`
- **Logs**: `/var/log/lancache/domain-collector.log`

### Manual Installation

```bash
# Copy script to system location
sudo cp lancache-domain-collector.sh /usr/local/bin/lancache-domain-collector
sudo chmod +x /usr/local/bin/lancache-domain-collector

# Install systemd service
sudo cp lancache-domain-collector.service /etc/systemd/system/
sudo systemctl daemon-reload
```

## Usage

### Start Service
```bash
sudo systemctl start lancache-domain-collector
```

### Enable Auto-Start on Boot
```bash
sudo systemctl enable lancache-domain-collector
```

### Check Status
```bash
sudo systemctl status lancache-domain-collector
```

### Stop Service
```bash
sudo systemctl stop lancache-domain-collector
```

### View Logs
```bash
sudo journalctl -u lancache-domain-collector -f
# or
sudo tail -f /var/log/lancache/domain-collector.log
```

### View Collected Domains
```bash
cat /var/lib/lancache/collected-domains.txt
```

## Features

- **Passive Monitoring**: Monitors DNS queries without modifying traffic
- **Automatic Service Detection**: Works with both `named` (RHEL/CentOS) and `bind9` (Debian/Ubuntu)
- **Domain Filtering**: Ignores common non-cacheable domains (Google, Facebook, etc.)
- **Auto-Restart**: Automatically restarts on failure
- **Timestamped Database**: Each domain is logged with collection timestamp

## How It Works

1. Monitors DNS service logs using `journalctl`
2. Extracts A and AAAA query domains
3. Filters out non-cacheable domains
4. Saves unique domains to database with timestamps
5. Runs continuously in background

## Integration

Can be controlled via `auto-cdn-detector.sh` menu:
- Menu Option 3: "Background Service Control"
- Start/Stop/Restart service
- Enable/Disable auto-start
- View status

## Troubleshooting

### Service won't start
```bash
# Check DNS service is running
sudo systemctl status named
# or
sudo systemctl status bind9

# Check service errors
sudo journalctl -u lancache-domain-collector -n 50
```

### No domains being collected
```bash
# Verify DNS queries are happening
sudo journalctl -u named -f
# or
sudo journalctl -u bind9 -f

# Check service is running
sudo systemctl status lancache-domain-collector
```

### Permission errors
```bash
# Ensure directories exist
sudo mkdir -p /var/lib/lancache
sudo mkdir -p /var/log/lancache

# Fix permissions if needed
sudo chown root:root /var/lib/lancache
sudo chmod 755 /var/lib/lancache
```

## Uninstallation

```bash
# Stop and disable service
sudo systemctl stop lancache-domain-collector
sudo systemctl disable lancache-domain-collector

# Remove files
sudo rm /etc/systemd/system/lancache-domain-collector.service
sudo rm /usr/local/bin/lancache-domain-collector
sudo systemctl daemon-reload

# Optionally remove data
sudo rm -rf /var/lib/lancache
sudo rm -rf /var/log/lancache
```
