# 🎮 LanCache - Ultimate Game CDN Cache Server

[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
[![Ubuntu](https://img.shields.io/badge/Ubuntu-22.04%20LTS-orange.svg)](https://ubuntu.com/)
[![Version](https://img.shields.io/badge/Version-5.0.0-green.svg)](https://github.com/saambd/lancache)

**Fully automated LAN caching solution with intelligent optimization and real-time monitoring**

Save up to **90% bandwidth** by caching game downloads from Steam, Epic Games, Origin, Battle.net, Riot Games, and 30+ gaming platforms.

---

## ✨ Key Features

- 🚀 **One-Command Installation** - Fully automated setup in 5 minutes
- 🧠 **Intelligent Auto-Configuration** - DNS, IP, reverse zones, datasources
- 💾 **Multi-Disk Support** - Automatic detection and load balancing
- 📊 **Professional Monitoring** - Grafana dashboards with 27 panels
- ⚡ **RAM-Based Optimization** - 4-16 workers based on available RAM
- 🗑️ **Complete Uninstall** - Full cleanup with partition wiping option

---

## 📋 System Requirements

| Component | Minimum | Recommended |
|-----------|---------|-------------|
| **OS** | Ubuntu 22.04 LTS | Ubuntu 22.04 LTS |
| **CPU** | 2 cores | 4+ cores |
| **RAM** | 4 GB | 8+ GB |
| **Cache Disk** | 100 GB | 500+ GB SSD |
| **Network** | 100 Mbps | 1 Gbps |

### RAM-Based Optimization

| RAM | Nginx Workers | File Descriptors | Level |
|-----|---------------|-----------------|-------|
| 4-7 GB | 4 workers | 131,072 | Basic |
| 8-15 GB | 8 workers | 262,144 | Medium |
| 16-31 GB | 12 workers | 524,288 | High |
| 32+ GB | 16 workers | 1,048,576 | Enterprise |

---

## 🚀 Quick Start

### Installation (3 commands)

```bash
# Clone repository
cd /opt/
sudo git clone https://github.com/saambd/lancache.git lancache-master
cd lancache-master

# Run automated installation
sudo chmod +x lancache-install.sh
sudo ./lancache-install.sh
```

**The installer automatically:**
1. Detects system resources (CPU, RAM, Network, IP)
2. Configures DNS with auto-detected IP, reverse zones, PTR records
3. Detects and configures cache disks
4. Installs Nginx, Bind9, Grafana, InfluxDB, Loki, Telegraf
5. Optimizes based on RAM (workers, connections, file descriptors)
6. Provisions Grafana dashboards with auto-datasources

### Access Dashboard

```
URL: http://YOUR_SERVER_IP:3000
Username: admin
Password: lancache
```

### Configure Clients

```
Primary DNS: YOUR_LANCACHE_SERVER_IP
Secondary DNS: 8.8.8.8
```

---

## 📊 Grafana Dashboard

### LanCache Monitor V5 - 27 Panels

**9-Panel Top Row:**
- System Uptime | CPU | RAM | Cache Disk Size | Cache Used | Cache Free | Bandwidth Saved | Download | Upload

**Monitoring (18 panels):**
- Cache Hit/Miss Ratio, Request Rate, Response Times, Top Games, DNS Stats, Network I/O, Disk I/O, Service Health

**Logs (6 panels):**
- Nginx Access/Error, Bind9 Queries, System Logs with full-text search

**Auto-Configuration:**
- All panels auto-connect to datasources using `${LancacheBD}` and `${LokiDB}` variables
- No manual UID configuration needed

---

## 🎯 Supported Gaming Platforms (35+)

Steam • Epic Games • Origin/EA • Battle.net • Riot Games • GOG • PlayStation • Xbox • Nintendo • Windows Update • Ubisoft • Rockstar • And 20+ more

---

## ⚡ Performance Optimizations

**Nginx:**
- RAM-based worker calculation (4-16 workers)
- Worker connections: 32,768 (optimized from 262,144)
- Memory usage: 86MB (reduced from 915MB - 87% improvement)

**Bind9:**
- Memory usage: 33MB
- Cache size: 512MB
- Recursive clients: 10,000
- TCP clients: 1,000

**Network:**
- BBR Congestion Control
- Large TCP buffers (128MB)
- Connection reuse enabled
- Optimized TCP timeout (15s)

---

## 🔧 Configuration

### DNS Auto-Configuration

Installer automatically:
- Detects server IP address
- Calculates reverse zone (e.g., `10.160.217.131` → `217.160.10.in-addr.arpa`)
- Generates PTR records from last IP octet
- Updates all DNS zone files

### Multi-Disk Setup

**Single Disk:**
- Mount: `/harddisk`
- Cache zone: `generic` (80% allocation)

**Multiple Disks:**
- Mounts: `/harddisk`, `/harddisk2`, `/harddisk3`
- Cache zones: `generic`, `cache2`, `cache3`
- Auto load balancing

---

## 🔐 DNS Domain Manager

### Interactive Domain Control

Manage DNS cache domains without restarting services using the built-in domain manager:

```bash
cd /opt/lancache-master
sudo ./dns-domain-manager.sh
```

**Features:**
- ✅ Enable/Disable domains with live toggle
- 📋 View all 35+ gaming platform domains
- 🔍 Filter domains by status (Active/Disabled/All)
- 💾 Automatic configuration backup before changes
- 🔄 Zero-downtime domain toggling
- 📊 Real-time domain status display

**How It Works:**

1. **Launch Manager:**
   ```bash
   sudo ./dns-domain-manager.sh
   ```
   - Auto-installs `dialog` if not present
   - Shows interactive menu with all domains

2. **Enable Domain:**
   - Select domain from list
   - Choose "Enable Domain"
   - Adds active DNS entry: `*.domain.com CNAME lancache.cache.`
   - Reloads Bind9 without restart
   - Clients immediately cache this domain

3. **Disable Domain:**
   - Select domain from list
   - Choose "Disable Domain"
   - Comments out entry: `; *.domain.com CNAME lancache.cache.`
   - Reloads Bind9 configuration
   - Clients bypass cache for this domain

4. **View Status:**
   - Filter by Active/Disabled/All
   - See current state of all domains
   - Check what's being cached

**Supported Domains:**
- Steam, Epic Games, Origin/EA, Battle.net
- Riot Games, GOG, PlayStation, Xbox
- Nintendo, Windows Update, Ubisoft, Rockstar
- And 20+ more gaming platforms

**Safety Features:**
- ✅ Automatic backups to `/var/backups/lancache/dns/`
- ✅ Validation before applying changes
- ✅ Logs all actions to `/var/log/lancache/dns-manager.log`
- ✅ Rollback capability from backups

**Example Use Cases:**

**Disable Windows Update temporarily:**
```bash
sudo ./dns-domain-manager.sh
# Select "windowsupdate" → Disable Domain
# Windows updates bypass cache, freeing disk space
```

**Enable only gaming platforms:**
```bash
# Disable non-gaming services (Windows Update, Apple, etc.)
# Keep only: Steam, Epic, Origin, Battle.net, etc.
# Optimizes cache for pure gaming traffic
```

**Troubleshoot specific platform:**
```bash
# If Steam downloads fail, disable Steam domain
# Downloads go direct, bypassing potential cache issues
# Re-enable after troubleshooting
```

---

## 🤖 Smart CDN Auto-Detector

### Intelligent Domain Discovery

Automatically discover and add cacheable domains using DNS log analysis and port scanning:

```bash
cd /opt/lancache-master
sudo ./auto-cdn-detector.sh
```

**V2 Features:**
- ✅ DNS log-based collection (no packet capture needed)
- ✅ Port 80 detection (HTTP only - cacheable domains)
- ✅ Background service for passive collection
- ✅ Active scan mode for immediate results
- ✅ Filters HTTPS-only domains automatically
- ✅ Lightweight & efficient (< 50MB RAM, 5% CPU)
- ✅ Cross-distribution compatibility (named/bind9 auto-detection)
- ✅ Professional installation to system directories

**How It Works:**

### **Option 1: Background Service (Recommended)**

Passively collects domains over days/weeks with minimal resources:

```bash
# Enable and start background service
sudo systemctl enable lancache-domain-collector
sudo systemctl start lancache-domain-collector

# Service runs continuously, collecting DNS queries
# Uses < 50MB RAM, 5% CPU
```

**After 1 week, review collected domains:**
```bash
sudo ./auto-cdn-detector.sh
# Menu: Option 1 - View & Add Collected Domains
# Shows: "Collected 234 domains over 7 days"
# Port 80 check runs automatically
# Select domains to add
```

### **Option 2: Active Scan Mode**

Scan DNS queries in real-time for 60 seconds:

```bash
sudo ./auto-cdn-detector.sh
# Menu: Option 2 - Run Active Scan

# Monitors DNS for 60s
# Collects all queried domains
# Port 80 check on completion
# Select domains to add immediately
```

**Process Flow:**

1. **Collection Phase:**
   - Monitor Bind9 DNS logs
   - Extract all queried domains
   - Store in `/var/lib/lancache/collected-domains.txt`

2. **Analysis Phase:**
   - Read collected domains
   - Test each for port 80 availability
   - Filter: Port 80 = Cacheable ✓
   - Filter: Port 443 only = Skip (HTTPS)
   - Skip already added domains

3. **Selection Phase:**
   - Show interactive checklist
   - Only cacheable (port 80) domains
   - You select which to add
   - DNS automatically updated

**Why Port 80 Check?**
- Port 80 = HTTP = Can be cached by Nginx ✓
- Port 443 = HTTPS = Encrypted, cannot cache ✗
- Only shows domains that will actually cache

**Menu Options:**

```
1. View & Add Collected Domains - Check port 80, select & add
2. Run Active Scan (60s)         - Real-time collection
3. Background Service Control    - Start/Stop/Enable service
4. View Collection Database      - See all collected domains
5. View Detection Log            - Detailed logs
6. Clear Database                - Start fresh
7. Configure Scan Duration       - Change from 60s
8. Exit
```

**Service Management:**

```bash
# Start service
sudo systemctl start lancache-domain-collector

# Enable auto-start on boot
sudo systemctl enable lancache-domain-collector

# Check status
sudo systemctl status lancache-domain-collector

# View service logs
sudo journalctl -u lancache-domain-collector -f
```

**Installation & File Structure:**

The domain collector follows professional Linux FHS (Filesystem Hierarchy Standard):

```
Source Files (for installation):
/opt/lancache-master/
├── domain-collector/
│   ├── lancache-domain-collector.sh      # Service script
│   ├── lancache-domain-collector.service # Systemd unit file
│   └── README.md                          # Full documentation

Installed System Files (after installation):
├── /usr/local/bin/lancache-domain-collector       # Executable script
├── /etc/systemd/system/lancache-domain-collector.service  # Service file
├── /var/lib/lancache/collected-domains.txt        # Domain database
└── /var/log/lancache/domain-collector.log         # Service logs
```

**Key Points:**
- ✅ **Independent Installation**: After `lancache-install.sh` runs, files are copied to system locations
- ✅ **Source-Independent**: Service runs from `/usr/local/bin/` - `/opt/lancache-master/` can be deleted
- ✅ **Professional Structure**: Follows Linux standard directories for binaries, configs, data, and logs
- ✅ **Automatic Setup**: Installation script handles all file copying and permissions

**Compatibility:**
- ✅ Auto-detects DNS service: `named` (RHEL/CentOS/Fedora) or `bind9` (Debian/Ubuntu)
- ✅ Dynamic service monitoring based on detected DNS server
- ✅ Works on all Linux distributions with systemd

**Example Workflow:**

**Day 1:** Enable service
```bash
sudo systemctl enable --now lancache-domain-collector
# Service running in background
```

**Day 7:** Review & add domains
```bash
sudo ./auto-cdn-detector.sh
# Option 1: View collected domains
# Analyzing 234 domains...
# Checking port 80... (takes 2-3 minutes)
#
# Cacheable Domains Found: 45
# ☑ cdn-content.example.com (Port 80 ✓)
# ☑ download.gameplatform.net (Port 80 ✓)
# ☐ api.socialmedia.com (Port 443 only - skipped)
#
# Select domains → Add to DNS
# ✓ Added 45 domains!
```

**Performance:**

| Mode | CPU | Memory | Network |
|------|-----|--------|---------|
| Background Service | 2-5% | 30-50MB | None |
| Active Scan | 5-10% | 50MB | None |
| Port 80 Check | 10-20% | 50MB | Minimal |

**Safety Features:**
- ✅ Never adds automatically - always requires approval
- ✅ Validates DNS before reload
- ✅ Backups before changes
- ✅ Logs all operations
- ✅ Skips already added domains

**Files & Logs:**
- Database: `/var/lib/lancache/collected-domains.txt`
- Log: `/var/log/lancache/cdn-detector.log`
- Service: `/etc/systemd/system/lancache-domain-collector.service`

---

## 🐛 Troubleshooting

### Cache Not Working
```bash
nslookup cdn.steampowered.com YOUR_LANCACHE_IP
sudo systemctl status nginx
df -h /harddisk
```

### Dashboard No Data
```bash
sudo systemctl status telegraf
sudo systemctl restart telegraf
# Wait 30 seconds and refresh
```

### DNS Not Resolving
```bash
sudo systemctl status bind9
sudo named-checkconf
dig @localhost cdn.steampowered.com
```

---

## 🗑️ Uninstallation

```bash
cd /opt/lancache-master
sudo chmod +x lancache-uninstall.sh
sudo ./lancache-uninstall.sh
```

**Removes:**
- All services (Nginx, Bind9, Grafana, InfluxDB, Loki, Telegraf)
- All cache data (`/harddisk/cache/*`)
- All logs (`/harddisk/logs/*`)
- Unmounts all cache disks
- Optional: Wipes partition tables

---

## 📊 Performance Metrics

**Bandwidth Savings:**
- Subsequent downloads: 90-95% saved
- Example: 100 users × 10GB game = 990GB saved

**Resource Usage (7GB RAM system):**

| Service | RAM | CPU |
|---------|-----|-----|
| Nginx | 86 MB | 2-5% |
| Bind9 | 33 MB | 1-2% |
| Grafana | 150 MB | 1-3% |
| InfluxDB | 200 MB | 2-4% |
| Loki | 100 MB | 1-2% |
| Telegraf | 50 MB | 1% |
| **Total** | **~620 MB** | **8-17%** |

---

## 📚 Documentation

### Service Logs
```bash
sudo journalctl -u nginx -f          # Nginx cache
sudo journalctl -u bind9 -f          # DNS server
sudo journalctl -u grafana-server -f # Dashboard
```

### Cache Management
```bash
# Clear all cache
sudo rm -rf /harddisk/cache/*
sudo systemctl restart nginx

# Check cache stats
curl http://localhost/lancache-heartbeat
df -h /harddisk
```

### Configuration Backup
```bash
sudo tar -czf lancache-backup-$(date +%F).tar.gz \
  /opt/lancache-master/ /etc/nginx/ /etc/bind/ /etc/grafana/
```

---

## 🎯 What's New in v5.0.0

**Auto-Configuration:**
- DNS IP auto-detection and reverse zone calculation
- PTR record auto-generation
- Grafana datasource auto-provisioning with 3-phase initialization
- Automatic Grafana dashboard import with authentication verification

**Performance:**
- RAM-based Nginx worker optimization (4-16 workers)
- Worker connections reduced to 32,768
- 87% memory reduction (915MB → 86MB)
- Dynamic file descriptors and TCP memory tuning

**Dashboard:**
- 9-panel optimized top row
- Auto-datasource variables (`${LancacheBD}`, `${LokiDB}`)
- Fixed "Cache Used" panel with auto-scaling units (GiB → TiB)
- Automatic import during installation with proper readiness checks

**Domain Collector Service (NEW):**
- Background service for passive DNS domain collection
- Auto-detects DNS service (named/bind9) across distributions
- Professional installation to system directories (`/usr/local/bin/`, `/etc/systemd/system/`)
- Service runs independently of source directory
- Systemd integration with auto-restart on failure

**Auto CDN Detector (ENHANCED):**
- Cross-distribution DNS compatibility (RHEL/Debian/Ubuntu)
- Improved port 80 checking with faster timeouts (3s → 2s)
- Netcat fallback for better reliability
- Dynamic service reload based on detected DNS server
- Professional file organization

**Professional Structure:**
- Organized source code into logical folders (domain-collector/, auto-cdn-detector/)
- Services install to FHS-compliant system locations
- Source repository can be safely removed after installation
- Complete documentation with troubleshooting guides

**Cleanup:**
- Removed adblock zones (simplified DNS)
- Enhanced uninstall with cache data removal
- Optional partition wiping

---

## 📞 Support

**Issues:** [GitHub Issues](https://github.com/saambd/lancache/issues)

**Repository:** https://github.com/saambd/lancache

---

## 📜 License

MIT License - See [LICENSE](LICENSE) file

---

## 🙏 Credits

LanCache.net • Ubuntu • Grafana Labs • Nginx • ISC Bind9 • InfluxData

---

**Version:** 5.0.0 | **Last Updated:** December 2025 | **Tested:** Ubuntu 22.04 LTS

**Made with ❤️ for the gaming community - Happy Caching! 🎮🚀**
