#!/bin/bash

export LANG=C
DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && cd .. && pwd )

if [ -x /opt/flussonic/bin/python3 ] ; then
  PYTHON=/opt/flussonic
else
  if [ -x "$DIR/flask/bin/python3" ]; then
    PYTHON="$DIR/flask"
  else
    PYTHON=/usr
  fi
fi

cd $DIR
if [ -z "$NODBCHECK" ] ; then
  MAINTENANCE="$($PYTHON/bin/python3 -m manage check)"
fi

if [ -z "$MAINTENANCE" ] ; then
  exec "$PYTHON/bin/python3" -m "$1" "${@:2}" 2>&1
else
  echo "$MAINTENANCE"
  MAINTENANCE=$MAINTENANCE exec "$PYTHON/bin/python3" "-m" "$1" "${@:2}" 2>&1
fi