"""remove_streampoint_key

Revision ID: 837b583b544b
Revises: 054cbf6fd571
Create Date: 2022-08-09 17:30:17.348044

"""

# revision identifiers, used by Alembic.
revision = '837b583b544b'
down_revision = '054cbf6fd571'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from watcher import utils


def upgrade():
    op.alter_column(
      'streamers', 'streampoint_key',
      existing_type=sa.VARCHAR(),
      nullable=True
    )


def downgrade():
    bind = op.get_bind()
    session = sa.orm.Session(bind=bind)
    meta = sa.schema.MetaData()
    meta.reflect(bind=bind)

    straeamers = meta.tables['streamers']
    streampoint_key = utils.rand_str(10)
    session.execute(
      straeamers.update().where(sa.or_(
        straeamers.c.streampoint_key.is_(None),
        straeamers.c.streampoint_key == ''
      )).values(streampoint_key=streampoint_key)
    )

    op.alter_column(
      'streamers', 'streampoint_key',
      existing_type=sa.VARCHAR(),
      nullable=False
    )
