"""fix_already_deleted_persons

Revision ID: 4abfbe3886ca
Revises: 4fbb72eb2683
Create Date: 2022-02-07 13:27:38.000425

"""

# revision identifiers, used by Alembic.
revision = '4abfbe3886ca'
down_revision = '4fbb72eb2683'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from datetime import datetime


def upgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)

  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  persons_table = meta.tables['activity_persons']

  session.execute(
      persons_table.update().where(
        persons_table.c.name.startswith("Deleted Person")
      ).values(deleted_at=datetime.utcnow())
  )
  session.commit()


def downgrade():
  pass
