"""add_license_plates_event_type

Revision ID: 4fbb72eb2683
Revises: da49b192a3f2
Create Date: 2022-01-25 18:43:44.290303

"""

# revision identifiers, used by Alembic.
revision = '4fbb72eb2683'
down_revision = 'da49b192a3f2'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
    op.add_column(
      'license_plates',
      sa.Column('event_type', sa.String(), server_default='license_plate', nullable=False)
    )
    op.create_index('license_plate_domain_id_idx', 'license_plates', ['domain_id'], unique=False)


def downgrade():
    op.drop_column('license_plates', 'event_type')
    op.drop_index('license_plate_domain_id_idx', table_name='license_plates')
