"""add_person_deleted_at

Revision ID: da49b192a3f2
Revises: v21.11
Create Date: 2022-01-12 14:43:27.673744

"""

# revision identifiers, used by Alembic.
revision = 'da49b192a3f2'
down_revision = 'v21.11'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column('activity_persons', sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True))
  op.create_index(op.f('ix_activity_persons_deleted_at'), 'activity_persons', ['deleted_at'], unique=False)


def downgrade():
  op.drop_index(op.f('ix_activity_persons_deleted_at'), table_name='activity_persons')
  op.drop_column('activity_persons', 'deleted_at')
