"""remove_folder_user_duplicate

Revision ID: ee1f6508aae0
Revises: 64a228e77325
Create Date: 2021-09-13 15:58:08.145936

"""

# revision identifiers, used by Alembic.
revision = 'ee1f6508aae0'
down_revision = '64a228e77325'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  folder_users = meta.tables['folder_users']

  # юзеры у которых по какой-то причине осказалось несколько одинаковых папок
  corrupt_folder_users_query = session.execute(
    sa.select([
      folder_users.c.folder_id,
      folder_users.c.user_id
    ])
    .group_by(folder_users.c.folder_id, folder_users.c.user_id)
    .having(sa.func.count(folder_users.c.id) > 1)
  )
  folder_users_to_delete = []
  for folder_id, user_id in corrupt_folder_users_query:
    folder_users_to_delete_q = session.execute(
      sa.select(
        [folder_users.c.id]
      ).where(sa.and_(
        folder_users.c.folder_id == folder_id,
        folder_users.c.user_id == user_id
      )).offset(1)
    )
    folder_users_to_delete.extend([f.id for f in folder_users_to_delete_q])

  if folder_users_to_delete:
    session.execute(
      folder_users.delete().where(folder_users.c.id.in_(folder_users_to_delete))
    )

  session.commit()
  op.create_index('folder_user', 'folder_users', ['folder_id', 'user_id'], unique=True)


def downgrade():
  op.drop_index('folder_user', table_name='folder_users')
