"""person created_at

Revision ID: 64a228e77325
Revises: 0b3cf8518761
Create Date: 2021-05-21 10:17:06.092677

"""

# revision identifiers, used by Alembic.
revision = '64a228e77325'
down_revision = '0b3cf8518761'

from datetime import datetime
import warnings
from alembic import op  # noqa: F402
import sqlalchemy as sa
from sqlalchemy import exc as sa_exc
from sqlalchemy.dialects import postgresql as pg  # noqa: F402

PERSONS = 'activity_persons'
FACES = 'activity_faces'


def upgrade():
  date_defaults = dict(default=datetime.utcnow, server_default=sa.func.current_timestamp())
  array_defaults = dict(default=[], server_default='{}')

  op.add_column(FACES, sa.Column('group_attempts', sa.Integer(), nullable=False, server_default='0'))
  op.add_column(FACES, sa.Column('organization_id', sa.Integer(), nullable=True))
  op.add_column(FACES, sa.Column('version', sa.Text(), nullable=True))
  op.create_foreign_key(
    f'{FACES}_organizations_fkey',
    FACES, 'organizations',
    ['organization_id'], ['id'],
    ondelete='SET NULL')

  op.add_column(PERSONS, sa.Column('updated_by', sa.Text(), nullable=True))
  op.add_column(PERSONS, sa.Column('created_at', sa.DateTime(timezone=True), nullable=False, **date_defaults))
  op.add_column(PERSONS, sa.Column('updated_at', sa.DateTime(timezone=True), nullable=False, **date_defaults))
  op.add_column(PERSONS, sa.Column('plate_numbers', pg.ARRAY(sa.Text()), nullable=False, **array_defaults))
  # pg8000 не поддерживает pg.ARRAY(pg.BYTEA())
  # op.add_column(PERSONS, sa.Column('previews', pg.ARRAY(pg.BYTEA()), nullable=False, **array_defaults))
  # op.add_column(PERSONS, sa.Column('vectors', pg.ARRAY(pg.BYTEA()), nullable=False, **array_defaults))
  op.add_column(PERSONS, sa.Column('user_id', sa.Integer(), nullable=True))
  op.drop_column(PERSONS, 'has_preview')
  op.alter_column(PERSONS, 'first_seen_at', nullable=True, server_default=None)
  op.alter_column(PERSONS, 'version', nullable=True, server_default=None)
  op.alter_column(PERSONS, 'last_seen_at', nullable=True, server_default=None)
  op.create_index('ix_activity_persons_user_id', PERSONS, ['user_id'])
  op.create_foreign_key(
    'activity_persons_user_id_fkey',
    PERSONS, 'users', ['user_id'], ['id'], ondelete='SET NULL'
  )


def downgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  with warnings.catch_warnings():
    warnings.simplefilter("ignore", category=sa_exc.SAWarning)
    meta.reflect(bind=bind)

  persons = meta.tables[PERSONS]
  now = datetime.utcfromtimestamp(0)
  session.execute(
    persons.update().values(first_seen_at=now)
    .where(persons.c.first_seen_at.is_(None))
  )
  session.execute(
    persons.update().values(last_seen_at=now)
    .where(persons.c.last_seen_at.is_(None))
  )
  session.execute(
    persons.update().values(version='')
    .where(persons.c.version.is_(None))
  )
  session.commit()

  op.drop_constraint(f'{FACES}_organizations_fkey', FACES, type_='foreignkey')
  op.drop_column(FACES, 'organization_id')
  op.drop_column(FACES, 'group_attempts')
  op.drop_column(FACES, 'version')

  op.add_column(PERSONS, sa.Column('has_preview', sa.Boolean(), nullable=True))
  op.drop_constraint('activity_persons_user_id_fkey', PERSONS, type_='foreignkey')
  op.drop_index('ix_activity_persons_user_id', table_name=PERSONS)
  op.drop_column(PERSONS, 'updated_by')
  op.drop_column(PERSONS, 'created_at')
  op.drop_column(PERSONS, 'updated_at')
  op.drop_column(PERSONS, 'plate_numbers')
  # op.drop_column(PERSONS, 'previews')
  # op.drop_column(PERSONS, 'vectors')
  op.drop_column(PERSONS, 'user_id')
  op.alter_column(PERSONS, 'first_seen_at', nullable=False, server_default=sa.func.current_timestamp())
  op.alter_column(PERSONS, 'last_seen_at', nullable=False, server_default=sa.func.current_timestamp())
  op.alter_column(PERSONS, 'version', nullable=False, server_default='')
