"""precise_thumbnails_days

Revision ID: b20c35b6411f
Revises: v21.08
Create Date: 2021-08-17 15:07:55.556898

"""

# revision identifiers, used by Alembic.
revision = 'b20c35b6411f'
down_revision = 'v21.08'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column(
    'cloud_streams',
    sa.Column('precise_thumbnails_days', sa.Integer(), server_default='0', nullable=False)
  )
  op.add_column(
    'presets',
    sa.Column('precise_thumbnails_days', sa.Integer(), server_default='0', nullable=False)
  )

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  presets_table = meta.tables['presets']
  cloud_streams_table = meta.tables['cloud_streams']

  session.execute(
    presets_table.update()
    .where(presets_table.c.vision_enabled.is_(True))
    .values(precise_thumbnails_days=3)
  )
  session.execute(
    cloud_streams_table.update()
    .where(cloud_streams_table.c.vision_enabled.is_(True))
    .values(precise_thumbnails_days=3)
  )

  update_query = cloud_streams_table.update().where(
    sa.and_(
      cloud_streams_table.c.motion_detector_settings['precise_thumbnails'].astext.cast(sa.Boolean).is_(True),
      sa.not_(cloud_streams_table.c.motion_detector_settings['precise_thumbnails_days'].astext.cast(sa.Integer).is_(None))  # noqa: E501
    )).values(
      precise_thumbnails_days=cloud_streams_table.c.motion_detector_settings['precise_thumbnails_days'].astext.cast(sa.Integer)  # noqa: E501
    )
  session.execute(update_query)
  session.commit()


def downgrade():
  op.drop_column('presets', 'precise_thumbnails_days')
  op.drop_column('cloud_streams', 'precise_thumbnails_days')
