"""add fkeys indexes

Revision ID: 7ee6c94eb405
Revises: 2df349906efa
Create Date: 2021-07-26 13:08:19.570130

"""

# revision identifiers, used by Alembic.
revision = '7ee6c94eb405'
down_revision = '2df349906efa'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.create_index(op.f('ix_cloud_streams_agent_id'), 'cloud_streams', ['agent_id'], unique=False)
  op.create_index(op.f('ix_cloud_streams_streamer_id'), 'cloud_streams', ['streamer_id'], unique=False)
  op.create_index(op.f('ix_deleted_streams_agent_id'), 'deleted_streams', ['agent_id'], unique=False)


def downgrade():
  op.drop_index(op.f('ix_cloud_streams_streamer_id'), table_name='cloud_streams')
  op.drop_index(op.f('ix_cloud_streams_agent_id'), table_name='cloud_streams')
  op.drop_index(op.f('ix_deleted_streams_agent_id'), table_name='deleted_streams')
