"""remove_worker_tasks

Revision ID: 2df349906efa
Revises: acc59ffa0208
Create Date: 2021-06-08 15:41:06.070071

"""

# revision identifiers, used by Alembic.
revision = '2df349906efa'
down_revision = 'acc59ffa0208'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  op.drop_index('ix_worker_tasks_queue', table_name='worker_tasks')
  op.drop_table('worker_tasks')


def downgrade():
  op.create_table(
    'worker_tasks',
    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('queue', sa.VARCHAR(), autoincrement=False, nullable=False),
    sa.Column(
      'created_at', postgresql.TIMESTAMP(), server_default=sa.text('now()'),
      autoincrement=False, nullable=False
    ),
    sa.Column('payload', sa.TEXT(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name='worker_tasks_pkey')
  )
  op.create_index('ix_worker_tasks_queue', 'worker_tasks', ['queue'], unique=False)
