"""add persons w/o vectors and imgs

Revision ID: 54cf96d2d9d6
Revises: 7a282dfdf61b
Create Date: 2021-01-22 18:00:00.570252

"""

# revision identifiers, used by Alembic.
revision = '54cf96d2d9d6'
down_revision = '7a282dfdf61b'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
    # ### Alembic commands ###
    op.alter_column('activity_persons', 'vector', existing_type=postgresql.BYTEA(), nullable=True)
    op.alter_column('activity_persons', 'preview', existing_type=postgresql.BYTEA(), nullable=True)
    op.create_index('activity_persons_123DFF_person_list_id', 'activity_persons', ['person_list_id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### Alembic commands ###
    op.execute('DELETE FROM activity_persons where vector is NULL or preview is NULL')
    op.drop_index('activity_persons_123DFF_person_list_id', table_name='activity_persons')
    op.alter_column('activity_persons', 'vector', existing_type=postgresql.BYTEA(), nullable=False)
    op.alter_column('activity_persons', 'preview', existing_type=postgresql.BYTEA(), nullable=False)
    # ### end Alembic commands ###
