"""add_organization_preset_index

Revision ID: 6f216269d67c
Revises: 89303c5b7347
Create Date: 2021-01-19 14:37:19.053103

"""

# revision identifiers, used by Alembic.
revision = '6f216269d67c'
down_revision = '89303c5b7347'

import warnings
from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  with warnings.catch_warnings():
    warnings.simplefilter("ignore", category=sa.exc.SAWarning)
    meta.reflect(bind=bind)

  organization_presets = meta.tables['organization_presets']

  # организации у которых по какой-то причине осказалось несколько одинаковых пресетов
  corrupt_org_presets_query = session.execute(
    sa.select([
      organization_presets.c.organization_id,
      organization_presets.c.preset_id
    ])
    .group_by(organization_presets.c.organization_id, organization_presets.c.preset_id)
    .having(sa.func.count(organization_presets.c.id) > 1)
  )
  org_presets_to_delete = []
  for org_id, preset_id in corrupt_org_presets_query:
    org_presets = session.execute(
      sa.select(
        [organization_presets.c.id]
      ).where(sa.and_(
        organization_presets.c.organization_id == org_id,
        organization_presets.c.preset_id == preset_id
      )).order_by(
        sa.desc(organization_presets.c.deleted_at)
      ).offset(1)
    )
    org_presets_to_delete.extend([r.id for r in org_presets])

  if org_presets_to_delete:
    session.execute(
      organization_presets.delete().where(
        organization_presets.c.id.in_(org_presets_to_delete)
      )
    )

  session.commit()
  op.create_index(
    'organization_preset',
    'organization_presets',
    ['organization_id', 'preset_id'],
    unique=True
  )


def downgrade():
    op.drop_index('organization_preset', table_name='organization_presets')
