"""add_streamer_status

Revision ID: e829fc47ab53
Revises: 3c79266426ae
Create Date: 2020-11-02 17:51:12.974052

"""

# revision identifiers, used by Alembic.
revision = 'e829fc47ab53'
down_revision = '3c79266426ae'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
      'streamer_statuses',
      sa.Column('created_at', sa.DateTime(), nullable=False),
      sa.Column('updated_at', sa.DateTime(), nullable=False),
      sa.Column('streamer_id', sa.Integer(), nullable=False),
      sa.Column('hostname', sa.String(), nullable=True),
      sa.Column('build', sa.Integer(), nullable=True),
      sa.Column('cpu_usage', sa.Integer(), nullable=True),
      sa.Column('http', sa.Integer(), nullable=True),
      sa.Column('input_kbit', sa.Integer(), nullable=True),
      sa.Column('memory_usage', sa.Integer(), nullable=True),
      sa.Column('online_streams', sa.Integer(), nullable=True),
      sa.Column('output_kbit', sa.Integer(), nullable=True),
      sa.Column('rproxy', sa.Boolean(), nullable=True),
      sa.Column('rproxy_running', sa.Boolean(), nullable=True),
      sa.Column('started_at', sa.BigInteger(), nullable=True),
      sa.Column('total_clients', sa.Integer(), nullable=True),
      sa.Column('total_streams', sa.Integer(), nullable=True),
      sa.Column('uptime', sa.Integer(), nullable=True),
      sa.Column('version', sa.String(), nullable=True),
      sa.Column('vsaas', sa.Boolean(), nullable=True),
      sa.Column('vsaas_branding', sa.Boolean(), nullable=True),
      sa.Column('vsaas_running', sa.Boolean(), nullable=True),
      sa.Column('error', sa.String(), nullable=True),
      sa.Column('status', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
      sa.Column('disks', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
      sa.Column('partitions', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
      sa.Column('extra', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
      sa.PrimaryKeyConstraint('streamer_id')
    )


def downgrade():
  op.drop_table('streamer_statuses')
