"""move notify url to params

Revision ID: 3c79266426ae
Revises: v20.11
Create Date: 2020-11-02 13:30:00.466821

"""

# revision identifiers, used by Alembic.
revision = '3c79266426ae'
down_revision = 'v20.11'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.schema import MetaData


def upgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  # update data first
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)

  meta = MetaData()
  meta.reflect(bind=bind)

  event_sub_table = meta.tables['event_subscriptions']
  upd_types = ['push_person_list', 'push_person_single', 'push_person_category']
  for row in session.execute(event_sub_table.select().where(event_sub_table.c.event_type.in_(upd_types))):
    url = row.notify_url
    notify_id = int(row.notification_type)
    if row.event_type == 'push_person_single':
      mode = 'single'
    if row.event_type == 'push_person_list':
      mode = 'list'
    if row.event_type == 'push_person_category':
      mode = 'category'
    web_params = {'url': url, 'method': 'get', 'params': {'mode': mode, 'id': notify_id}}
    session.execute(event_sub_table.update().where(event_sub_table.c.id == row.id).values({
      'webhook_params': web_params, 'event_type': 'person_detected', 'notification_type': 'http'
    }))
  session.commit()
  op.drop_column('event_subscriptions', 'notify_url')
  # ### end Alembic commands ###


def downgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  op.add_column('event_subscriptions', sa.Column('notify_url', sa.TEXT(), autoincrement=False, nullable=True))
  # update data then
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)

  meta = MetaData()
  meta.reflect(bind=bind)

  event_sub_table = meta.tables['event_subscriptions']
  event_type = 'person_detected'
  for row in session.execute(event_sub_table.select().where(event_sub_table.c.event_type == event_type)
                             .where(event_sub_table.c.notification_type == 'http')):
    params = row.webhook_params.get('params')
    if not params:
      continue
    url = row.webhook_params.get('url')
    mode = params.get('mode')
    notify_id = params.get('id')  # int(row.notification_type)
    if mode == 'single':
      event_type = 'push_person_single'
    if mode == 'list':
      event_type = 'push_person_list'
    if mode == 'category':
      event_type = 'push_person_category'
    session.execute(event_sub_table.update().where(event_sub_table.c.id == row.id).values({
      'notify_url': url, 'event_type': event_type, 'notification_type': f'{notify_id}'
    }))  # do not delete webhook_params - just in case
  session.commit()
  # ### end Alembic commands ###
