"""organization_only_one_owner

Revision ID: e93eb144a9b6
Revises: 61f7e5a4a259
Create Date: 2020-10-09 12:05:28.950525

"""

# revision identifiers, used by Alembic.
revision = 'e93eb144a9b6'
down_revision = '61f7e5a4a259'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
import warnings
from sqlalchemy import exc as sa_exc
from sqlalchemy.dialects import postgresql  # noqa: F402
from sqlalchemy import select, or_, and_, func


def upgrade():
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  from watcher.models import Domain, User, CloudStream, Organization

  meta = sa.schema.MetaData()
  with warnings.catch_warnings():
    warnings.simplefilter("ignore", category=sa_exc.SAWarning)
    meta.reflect(bind=bind)

  organization_users = meta.tables['organization_users']

  # организации у которых по какой-то причине осказалось несколько владельцев
  corrupt_orgs_query = session.execute(
    sa.select([
      organization_users.c.organization_id,
      sa.func.array_agg(organization_users.c.user_id)
    ])
    .where(organization_users.c.is_owner.is_(True))
    .group_by(organization_users.c.organization_id)
    .having(sa.func.count(organization_users.c.user_id) > 1)
  )

  for org_id, owners in corrupt_orgs_query:
    main_owner = owners[0]

    session.execute(
      organization_users.update()
      .values(is_owner=False)
      .where(and_(
        organization_users.c.organization_id == org_id,
        organization_users.c.is_owner.is_(True),
        organization_users.c.user_id != main_owner,
      ))
    )

  session.commit()
  op.create_index(
    'organization_only_one_owner',
    'organization_users', ['organization_id', 'is_owner'],
    unique=True, postgresql_where=sa.text('is_owner IS true')
  )


def downgrade():
  op.drop_index('organization_only_one_owner', table_name='organization_users')
