"""org id added for person list

Revision ID: 61f7e5a4a259
Revises: 87ebf23a1641
Create Date: 2020-10-01 12:10:00.515784

"""

# revision identifiers, used by Alembic.
revision = '61f7e5a4a259'
down_revision = '87ebf23a1641'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.create_index('face_index_123DBF_end_at', 'activity_faces', ['end_at'], unique=False)
  op.add_column('person_list', sa.Column('organization_id', sa.Integer(), nullable=True))
  op.create_foreign_key(None, 'person_list', 'organizations', ['organization_id'], ['id'], ondelete='SET NULL')
  op.alter_column(table_name='person_list', column_name='data', new_column_name='config',
                  type_=postgresql.JSONB(astext_type=sa.Text()), server_default=sa.text("'{}'::jsonb"))
  op.add_column('activity_persons', sa.Column('organization_id', sa.Integer(), nullable=True))
  op.create_foreign_key(None, 'activity_persons', 'organizations', ['organization_id'], ['id'], ondelete='SET NULL')


def downgrade():
  op.alter_column(table_name='person_list', column_name='config', new_column_name='data')
  op.drop_index('face_index_123DBF_end_at', table_name='activity_faces')
  op.drop_column('person_list', 'organization_id')
  op.drop_column('activity_persons', 'organization_id')
