"""source_events

Revision ID: 58e696756163
Revises: 9e42ff5370fd
Create Date: 2020-07-22 17:11:32.695564

"""

# revision identifiers, used by Alembic.
revision = '58e696756163'
down_revision = '9e42ff5370fd'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  op.create_table(
    'source_events',
    sa.Column('id', sa.String(length=36), nullable=False),
    sa.Column('camera_id', sa.String(), nullable=True),
    sa.Column('server', sa.String(), nullable=True),
    sa.Column('event_type', sa.String(), nullable=True),
    sa.Column('reason', sa.String(), nullable=True),
    sa.Column('start_at', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
  )
  op.create_index(op.f('ix_source_events_start_at'), 'source_events', ['start_at'], unique=False)
  op.create_table(
    'source_events_stats',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('camera_id', sa.String(), nullable=True),
    sa.Column('server', sa.String(), nullable=True),
    sa.Column('period', sa.String(), nullable=True),
    sa.Column('period_start_time', sa.Integer(), nullable=True),
    sa.Column('source_ready_count', sa.Integer(), nullable=True),
    sa.Column('source_lost_count', sa.Integer(), nullable=True),
    sa.Column('source_lost_reasons', postgresql.JSONB(astext_type=sa.Text()), server_default='{}', nullable=False),
    sa.PrimaryKeyConstraint('id')
  )


def downgrade():
  op.drop_table('source_events_stats')
  op.drop_index(op.f('ix_source_events_start_at'), table_name='source_events')
  op.drop_table('source_events')
