"""metrics

Revision ID: 9e42ff5370fd
Revises: 5e4e6f7c8573
Create Date: 2020-07-08 14:22:46.832408

"""

# revision identifiers, used by Alembic.

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy import orm
from sqlalchemy.dialects import postgresql  # noqa: F402


revision = '9e42ff5370fd'
down_revision = '5e4e6f7c8573'


def upgrade():
  op.create_table(
    'watcher_metrics',
    sa.Column('pid', sa.Text(), primary_key=True),
    sa.Column('name', sa.Text(), primary_key=True),
    sa.Column('type', sa.Text(), nullable=False),
    sa.Column('help', sa.Text(), nullable=False),
    sa.Column('samples', sa.ARRAY(sa.Text), nullable=False, server_default='{}'),
    sa.Column('timestamps', sa.ARRAY(sa.Float), nullable=False, server_default='{}'),

    sa.PrimaryKeyConstraint('pid', 'name', name='watcher_metrics_pk')
  )

  bind = op.get_bind()
  session = orm.Session(bind=bind)
  session.execute('ALTER TABLE watcher_metrics SET UNLOGGED')
  session.commit()


def downgrade():
  op.drop_table('watcher_metrics')
