"""camera_vision_alg

Revision ID: a1ecd76da5e8
Revises: 73890c17e7b4
Create Date: 2020-07-08 14:04:32.254475

"""

# revision identifiers, used by Alembic.
revision = 'a1ecd76da5e8'
down_revision = '73890c17e7b4'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column('cloud_streams', sa.Column('vision_alg', sa.String(), nullable=True))
  op.add_column('deleted_streams', sa.Column('vision_alg', sa.String(), nullable=True))

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  cloud_streams_table = meta.tables['cloud_streams']
  deleted_streams_table = meta.tables['deleted_streams']

  session.execute(
    cloud_streams_table.update().where(
      cloud_streams_table.c.vision_enabled.is_(True)
    ).values(vision_alg='plates')
  )

  session.execute(
    deleted_streams_table.update().where(
      deleted_streams_table.c.vision_enabled.is_(True)
    ).values(vision_alg='plates')
  )

  session.commit()


def downgrade():
  op.drop_column('cloud_streams', 'vision_alg')
  op.drop_column('deleted_streams', 'vision_alg')
