"""add_camera_streamers

Revision ID: 772e49544a48
Revises: 01ed913cb43f
Create Date: 2020-04-14 17:27:32.015793

"""

# revision identifiers, used by Alembic.
revision = '772e49544a48'
down_revision = '01ed913cb43f'

from datetime import datetime  # noqa: F402
from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  op.create_table(
    'camera_streamers',
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('camera_id', sa.String(), nullable=False),
    sa.Column('streamer_id', sa.Integer(), nullable=False),
    sa.Column('selected', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['camera_id'], ['cloud_streams.name'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['streamer_id'], ['streamers.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sqlite_autoincrement=True
  )
  op.create_index('camera_streamers_unq', 'camera_streamers', ['camera_id', 'streamer_id'], unique=True)

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)
  cloud_streams = meta.tables['cloud_streams']
  camera_streamers = meta.tables['camera_streamers']

  camera_streamers_values = []

  for camera_id, streamer_id in session.query(cloud_streams.c.name, cloud_streams.c.streamer_id).filter(
    (cloud_streams.c.dvr_depth != 0)
    & cloud_streams.c.dvr_depth.isnot(None)
    & cloud_streams.c.streamer_id.isnot(None)
  ):
    camera_streamers_values.append({
      'streamer_id': streamer_id,
      'camera_id': camera_id,
      'selected': True,
      'created_at': datetime.utcnow(),
      'updated_at': datetime.utcnow()
    })

  if camera_streamers_values:
    session.execute(camera_streamers.insert().values(camera_streamers_values))

  session.commit()


def downgrade():
  op.drop_index('camera_streamers_unq', table_name='camera_streamers')
  op.drop_table('camera_streamers')
  # ### end Alembic commands ###
