"""remove_userdata

Revision ID: 01ed913cb43f
Revises: 1d0ae20a3469
Create Date: 2020-04-06 10:46:11.023392

"""

# revision identifiers, used by Alembic.
revision = '01ed913cb43f'
down_revision = '1d0ae20a3469'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column(
    'users',
    sa.Column('favorite_cameras', postgresql.ARRAY(sa.String()), server_default='{}', nullable=False)
  )
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)
  users = meta.tables['users']
  user_data = meta.tables['user_data']
  cloud_streams = meta.tables['cloud_streams']

  favs_by_users = (
    session.query(user_data.c.user_id, sa.func.array_agg(user_data.c.value))
    .filter(user_data.c.key == 'fav')
    .join(cloud_streams, user_data.c.value == cloud_streams.c.name)
    .join(users, user_data.c.user_id == users.c.id)
    .group_by(user_data.c.user_id)
  )
  for user_id, fav_cams in favs_by_users:
    session.execute(
      users.update(users.c.id == user_id).values(favorite_cameras=fav_cams)
    )

  op.drop_table('user_data')


def downgrade():
  op.create_table(
    'user_data',
    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('target', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('key', sa.VARCHAR(length=20), autoincrement=False, nullable=False),
    sa.Column('value', sa.TEXT(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], name='user_data_user_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='user_data_pkey')
  )

  op.drop_column('users', 'favorite_cameras')
