"""delete_old_tables

Revision ID: 1d0ae20a3469
Revises: v20.04
Create Date: 2020-04-03 15:12:16.062910

"""

# revision identifiers, used by Alembic.
revision = '1d0ae20a3469'
down_revision = 'v20.04'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('file_share_refs', table_name='file_shares')
    op.drop_index('file_userdata_refs', table_name='file_shares')
    op.drop_index('user_group', table_name='user_groups')
    op.drop_index('group_camera', table_name='group_cameras')
    op.drop_index('user_camera', table_name='user_cameras')

    op.drop_table('file_shares')
    op.drop_table('group_cameras')
    op.drop_table('user_groups')
    op.drop_table('groups')
    op.drop_table('motion_events')
    op.drop_table('user_cameras')
    op.drop_table('file_userdata')
    op.drop_table('files')

    op.drop_index('config_key', table_name='config')
    op.drop_index('idx_preset_cameras', table_name='preset_cameras')


def downgrade():
    op.create_index('idx_preset_cameras', 'preset_cameras', ['preset_id', 'camera_id'], unique=False)
    op.create_index('config_key', 'config', ['grp', 'name'], unique=True)

    op.create_table(
      'files',
      sa.Column('id', sa.VARCHAR(length=32), autoincrement=False, nullable=False),
      sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('title', sa.VARCHAR(length=250), autoincrement=False, nullable=False),
      sa.Column('note', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('coordinates', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('postal_address', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('source', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('server', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('created_at', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('start_utc', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('size', sa.INTEGER(), autoincrement=False, nullable=True),
      sa.Column('is_saved', sa.BOOLEAN(), autoincrement=False, nullable=False),
      sa.Column('path', sa.VARCHAR(length=500), autoincrement=False, nullable=True),
      sa.ForeignKeyConstraint(['user_id'], ['users.id'], name='files_user_id_fkey'),
      sa.PrimaryKeyConstraint('id', name='files_pkey'),
      postgresql_ignore_search_path=False
    )

    op.create_table(
      'file_userdata',
      sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
      sa.Column('file_id', sa.VARCHAR(length=32), autoincrement=False, nullable=False),
      sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('is_seen', sa.BOOLEAN(), autoincrement=False, nullable=False),
      sa.Column('is_pinned', sa.BOOLEAN(), autoincrement=False, nullable=False),
      sa.Column('is_hidden', sa.BOOLEAN(), autoincrement=False, nullable=False),
      sa.Column('note', sa.TEXT(), autoincrement=False, nullable=True),
      sa.ForeignKeyConstraint(['file_id'], ['files.id'], name='file_userdata_file_id_fkey'),
      sa.ForeignKeyConstraint(['user_id'], ['users.id'], name='file_userdata_user_id_fkey'),
      sa.PrimaryKeyConstraint('id', name='file_userdata_pkey')
    )

    op.create_table(
      'user_cameras',
      sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
      sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('camera_id', sa.TEXT(), autoincrement=False, nullable=False),
      sa.Column('order_num', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('comment', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('can_ptz', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
      sa.Column('can_dvr', sa.BOOLEAN(), server_default=sa.text('true'), autoincrement=False, nullable=True),
      sa.ForeignKeyConstraint(['user_id'], ['users.id'], name='user_cameras_user_id_fkey'),
      sa.PrimaryKeyConstraint('id', name='user_cameras_pkey')
    )

    op.create_index('user_camera', 'user_cameras', ['user_id', 'camera_id'], unique=True)

    op.create_table(
      'groups',
      sa.Column(
        'id', sa.INTEGER(), server_default=sa.text("nextval('groups_id_seq'::regclass)"),
        autoincrement=True, nullable=False
      ),
      sa.Column('streamer_id', sa.INTEGER(), autoincrement=False, nullable=True),
      sa.Column('title', sa.TEXT(), autoincrement=False, nullable=False),
      sa.Column('poster', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('coordinates', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('postal_address', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('note', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('max_cam_slots', sa.INTEGER(), autoincrement=False, nullable=True),
      sa.Column('max_dvr_days', sa.INTEGER(), autoincrement=False, nullable=True),
      sa.Column('max_dvr_space', sa.INTEGER(), autoincrement=False, nullable=True),
      sa.Column('max_user_slots', sa.INTEGER(), autoincrement=False, nullable=True),
      sa.ForeignKeyConstraint(['streamer_id'], ['streamers.id'], name='groups_streamer_id_fkey', ondelete='SET NULL'),
      sa.PrimaryKeyConstraint('id', name='groups_pkey'),
      sa.UniqueConstraint('title', name='groups_title_key'),
      postgresql_ignore_search_path=False
    )

    op.create_table(
      'group_cameras',
      sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
      sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('camera_id', sa.TEXT(), autoincrement=False, nullable=False),
      sa.Column('order_num', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('comment', sa.TEXT(), autoincrement=False, nullable=True),
      sa.ForeignKeyConstraint(['group_id'], ['groups.id'], name='group_cameras_group_id_fkey'),
      sa.PrimaryKeyConstraint('id', name='group_cameras_pkey')
    )
    op.create_index('group_camera', 'group_cameras', ['group_id', 'camera_id'], unique=True)

    op.create_table(
      'motion_events',
      sa.Column('source', sa.TEXT(), autoincrement=False, nullable=False),
      sa.Column('block_utc', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('block_interval', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('block_data', sa.BIGINT(), autoincrement=False, nullable=True),
      sa.PrimaryKeyConstraint('source', 'block_utc', 'block_interval', name='motion_events_pkey')
    )

    op.create_table(
      'user_groups',
      sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
      sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('order_num', sa.INTEGER(), autoincrement=False, nullable=False),
      sa.Column('comment', sa.TEXT(), autoincrement=False, nullable=True),
      sa.Column('can_ptz', sa.BOOLEAN(), autoincrement=False, nullable=True),
      sa.Column('can_dvr', sa.BOOLEAN(), autoincrement=False, nullable=True),
      sa.Column('can_manage_users', sa.BOOLEAN(), autoincrement=False, nullable=True),
      sa.Column('can_manage_cameras', sa.BOOLEAN(), autoincrement=False, nullable=True),
      sa.ForeignKeyConstraint(['group_id'], ['groups.id'], name='user_groups_group_id_fkey', ondelete='CASCADE'),
      sa.ForeignKeyConstraint(['user_id'], ['users.id'], name='user_groups_user_id_fkey', ondelete='CASCADE'),
      sa.PrimaryKeyConstraint('id', name='user_groups_pkey')
    )
    op.create_index('user_group', 'user_groups', ['user_id', 'group_id'], unique=True)

    op.create_table(
      'file_shares',
      sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
      sa.Column('file_id', sa.VARCHAR(length=32), autoincrement=False, nullable=False),
      sa.Column('user_id', sa.INTEGER(), autoincrement=False, nullable=True),
      sa.Column('group_id', sa.INTEGER(), autoincrement=False, nullable=True),
      sa.ForeignKeyConstraint(['file_id'], ['files.id'], name='file_shares_file_id_fkey'),
      sa.ForeignKeyConstraint(['group_id'], ['groups.id'], name='file_shares_group_id_fkey'),
      sa.ForeignKeyConstraint(['user_id'], ['users.id'], name='file_shares_user_id_fkey'),
      sa.PrimaryKeyConstraint('id', name='file_shares_pkey')
    )
    op.create_index('file_userdata_refs', 'file_shares', ['file_id', 'user_id', 'group_id'], unique=True)
    op.create_index('file_share_refs', 'file_shares', ['file_id', 'user_id', 'group_id'], unique=True)
    # ### end Alembic commands ###
