"""remove_sqlalchemy_mptt

Revision ID: a59e7d3f28fd
Revises: 3f7e2d226eea
Create Date: 2020-01-24 14:34:24.163271

"""

# revision identifiers, used by Alembic.
revision = 'a59e7d3f28fd'
down_revision = '3f7e2d226eea'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.sql import select, and_  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402


def upgrade():
  op.add_column('folders', sa.Column('ancestors', postgresql.ARRAY(sa.Integer()), server_default='{}', nullable=False))
  op.add_column('folders', sa.Column('order_num', sa.Integer(), server_default="1", nullable=False))

  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)
  folders = meta.tables['folders']

  roots = session.execute(folders.select().where(folders.c.parent_id.is_(None)))

  def get_children(folder):
    return session.execute(
      folders.select().where(folders.c.parent_id == folder.id).order_by(folders.c.lft)
    ).fetchall()

  def set_children_attrs(folder, ancestors):
    ancestors = ancestors + [folder.id, ]
    for oreder_num, child in enumerate(get_children(folder), 1):
      session.execute(
        folders.update(folders.c.id == child.id).values(
          order_num=oreder_num,
          ancestors=ancestors
        )
      )

      set_children_attrs(child, ancestors)

  for root in roots:
    set_children_attrs(root, ancestors=[])

  # don't delete old meta columns for a while
  op.alter_column(
    table_name='folders',
    column_name='lft',
    server_default='0'
  )
  op.alter_column(
    table_name='folders',
    column_name='rgt',
    server_default='0'
  )
  op.alter_column(
    table_name='folders',
    column_name='level',
    server_default='0'
  )


def downgrade():
  # op.add_column('folders', sa.Column('tree_id', sa.INTEGER(), autoincrement=False, nullable=True))
  # op.add_column('folders', sa.Column('rgt', sa.INTEGER(), autoincrement=False, nullable=False))
  # op.add_column('folders', sa.Column('level', sa.INTEGER(), autoincrement=False, nullable=False))
  # op.add_column('folders', sa.Column('lft', sa.INTEGER(), autoincrement=False, nullable=False))
  op.drop_column('folders', 'order_num')
  op.drop_column('folders', 'ancestors')
