"""change session usage, create requests log

Revision ID: d7e1d0f753dd
Revises: f3eec36a571d
Create Date: 2019-10-28 10:30:48.170932

"""

# revision identifiers, used by Alembic.
revision = 'd7e1d0f753dd'
down_revision = 'f3eec36a571d'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.dialects.postgresql import JSONB  # noqa: F402


def upgrade():
  op.create_table(
    'request_entries',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('version', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('data', JSONB(), nullable=False, server_default=sa.text("'{}'::jsonb")),
    sa.PrimaryKeyConstraint('id')
  )

  op.execute('TRUNCATE TABLE session_usages')

  op.drop_index('ix_session_usages_session_id', table_name='session_usages')

  op.drop_column('session_usages', 'created_at')
  op.drop_column('session_usages', 'updated_at')
  op.drop_column('session_usages', 'dvr_request_duration')
  op.drop_column('session_usages', 'dvr_request_from')
  op.drop_column('session_usages', 'referer')

  op.alter_column('session_usages', 'type', existing_type=sa.VARCHAR(), nullable=False)
  op.alter_column(
    'session_usages', 'session_id', existing_type=sa.VARCHAR(length=40), type_=sa.String(), existing_nullable=False
  )

  op.add_column('session_usages', sa.Column('camera_id', sa.String(), nullable=False))
  op.add_column('session_usages', sa.Column('data', JSONB(), nullable=False, server_default=sa.text("'{}'::jsonb")))
  op.add_column('session_usages', sa.Column('processed', sa.Boolean(), nullable=False))
  op.add_column('session_usages', sa.Column('created_at', sa.DateTime(), nullable=False))
  op.add_column('session_usages', sa.Column('updated_at', sa.DateTime(), nullable=False))

  op.create_index(
    'ix_session_usages_uniq_session_id_type', 'session_usages', ['session_id', 'type'],
    unique=True
  )
  op.create_index(
    'ix_session_usages_not_processed', 'session_usages', ['id'],
    unique=False,
    postgresql_where=sa.text('processed IS false')
  )


def downgrade():
  op.execute('TRUNCATE TABLE session_usages')

  op.drop_index('ix_session_usages_uniq_session_id_type', table_name='session_usages')
  op.drop_index('ix_session_usages_not_processed', table_name='session_usages')
  op.drop_column('session_usages', 'created_at')
  op.drop_column('session_usages', 'updated_at')
  op.drop_column('session_usages', 'processed')
  op.drop_column('session_usages', 'data')
  op.drop_column('session_usages', 'camera_id')

  op.alter_column('session_usages', 'type', existing_type=sa.VARCHAR(), nullable=True)
  op.alter_column(
    'session_usages', 'session_id', existing_type=sa.String(), type_=sa.VARCHAR(length=40), existing_nullable=False
  )

  op.add_column('session_usages', sa.Column('created_at', sa.INTEGER(), autoincrement=False, nullable=False))
  op.add_column('session_usages', sa.Column('updated_at', sa.INTEGER(), autoincrement=False, nullable=True))
  op.add_column('session_usages', sa.Column('referer', sa.VARCHAR(), autoincrement=False, nullable=True))
  op.add_column('session_usages', sa.Column('dvr_request_from', sa.BIGINT(), autoincrement=False, nullable=False))
  op.add_column(
    'session_usages',
    sa.Column('dvr_request_duration', sa.BIGINT(), server_default='0', autoincrement=False, nullable=False)
  )

  op.create_index('ix_session_usages_session_id', 'session_usages', ['session_id'], unique=True)

  op.drop_table('request_entries')
