"""cascade delete for service tables

Revision ID: f3eec36a571d
Revises: 8e329c18646b
Create Date: 2019-10-15 19:33:46.421148

"""

# revision identifiers, used by Alembic.
revision = 'f3eec36a571d'
down_revision = '8e329c18646b'

from alembic import op # noqa 402
import sqlalchemy as sa # noqa 402
from sqlalchemy.dialects import postgresql # noqa 402


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('folder_users_user_id_fkey', 'folder_users', type_='foreignkey')
    op.drop_constraint('folder_users_folder_id_fkey', 'folder_users', type_='foreignkey')

    op.create_foreign_key(
        'folder_users_folder_id_fkey', 'folder_users', 'folders', ['folder_id'], ['id'], ondelete='CASCADE')
    op.create_foreign_key(
        'folder_users_user_id_fkey', 'folder_users', 'users', ['user_id'], ['id'], ondelete='CASCADE')

    op.drop_constraint(
        'agent_activation_tokens_user_id_fkey', 'agent_activation_tokens', type_='foreignkey')
    op.create_foreign_key(
        'agent_activation_tokens_user_id_fkey', 'agent_activation_tokens', 'users', ['user_id'], ['id'],
        ondelete='CASCADE'
    )

    op.drop_constraint(
        'organization_presets_preset_id_fkey', 'organization_presets', type_='foreignkey')
    op.create_foreign_key(
        'organization_presets_preset_id_fkey', 'organization_presets', 'presets', ['preset_id'], ['id'],
        ondelete='CASCADE'
    )

    op.drop_constraint(
        'organization_presets_organization_id_fkey', 'organization_presets', type_='foreignkey')
    op.create_foreign_key(
        'organization_presets_organization_id_fkey', 'organization_presets', 'organizations', ['organization_id'],
        ['id'], ondelete='CASCADE'
    )

    op.drop_constraint(
        'organization_users_organization_id_fkey', 'organization_users', type_='foreignkey')
    op.create_foreign_key(
        'organization_users_organization_id_fkey', 'organization_users', 'organizations', ['organization_id'], ['id'],
        ondelete='CASCADE'
    )

    op.drop_constraint(
        'organization_users_user_id_fkey', 'organization_users', type_='foreignkey')
    op.create_foreign_key(
        'organization_users_user_id_fkey', 'organization_users', 'users', ['user_id'], ['id'], ondelete='CASCADE')

    op.drop_constraint(
        'user_data_user_id_fkey', 'user_data', type_='foreignkey')
    op.create_foreign_key(
        'user_data_user_id_fkey', 'user_data', 'users', ['user_id'], ['id'], ondelete='CASCADE')

    op.drop_constraint(
        'user_groups_user_id_fkey', 'user_groups', type_='foreignkey')
    op.create_foreign_key(
        'user_groups_user_id_fkey', 'user_groups', 'users', ['user_id'], ['id'], ondelete='CASCADE')

    op.drop_constraint(
        'user_groups_group_id_fkey', 'user_groups', type_='foreignkey')
    op.create_foreign_key(
        'user_groups_group_id_fkey', 'user_groups', 'groups', ['group_id'], ['id'], ondelete='CASCADE')

    op.drop_constraint(
        'watcher_sessions_user_id_fkey', 'watcher_sessions', type_='foreignkey')
    op.create_foreign_key(
        'watcher_sessions_user_id_fkey', 'watcher_sessions', 'users', ['user_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('folder_users_folder_id_fkey', 'folder_users', type_='foreignkey')
    op.drop_constraint('folder_users_user_id_fkey', 'folder_users', type_='foreignkey')
    op.create_foreign_key(
        'folder_users_folder_id_fkey', 'folder_users', 'folders', ['folder_id'], ['id'])
    op.create_foreign_key(
        'folder_users_user_id_fkey', 'folder_users', 'users', ['user_id'], ['id'])

    op.drop_constraint(
        'watcher_sessions_user_id_fkey', 'watcher_sessions', type_='foreignkey')
    op.create_foreign_key(
        'watcher_sessions_user_id_fkey', 'watcher_sessions', 'users', ['user_id'], ['id'])

    op.drop_constraint(
        'user_groups_group_id_fkey', 'user_groups', type_='foreignkey')
    op.create_foreign_key(
        'user_groups_group_id_fkey', 'user_groups', 'groups', ['group_id'], ['id'])

    op.drop_constraint(
        'user_groups_user_id_fkey', 'user_groups', type_='foreignkey')
    op.create_foreign_key(
        'user_groups_user_id_fkey', 'user_groups', 'users', ['user_id'], ['id'])

    op.drop_constraint(
        'user_data_user_id_fkey', 'user_data', type_='foreignkey')
    op.create_foreign_key(
        'user_data_user_id_fkey', 'user_data', 'users', ['user_id'], ['id'])

    op.drop_constraint(
        'organization_users_user_id_fkey', 'organization_users', type_='foreignkey')
    op.create_foreign_key(
        'organization_users_user_id_fkey', 'organization_users', 'users', ['user_id'], ['id'])

    op.drop_constraint(
        'organization_users_organization_id_fkey', 'organization_users', type_='foreignkey')
    op.create_foreign_key(
        'organization_users_organization_id_fkey', 'organization_users', 'organizations', ['organization_id'], ['id'])

    op.drop_constraint(
        'organization_presets_organization_id_fkey', 'organization_presets', type_='foreignkey')
    op.create_foreign_key(
        'organization_presets_organization_id_fkey', 'organization_presets', 'organizations',
        ['organization_id'], ['id']
    )

    op.drop_constraint(
        'organization_presets_preset_id_fkey', 'organization_presets', type_='foreignkey')
    op.create_foreign_key(
        'organization_presets_preset_id_fkey', 'organization_presets', 'presets', ['preset_id'], ['id'])

    op.drop_constraint(
        'agent_activation_tokens_user_id_fkey', 'agent_activation_tokens', type_='foreignkey')
    op.create_foreign_key(
        'agent_activation_tokens_user_id_fkey', 'agent_activation_tokens', 'users', ['user_id'], ['id'])
