"""change_presets_relation

Revision ID: bb52cbd644f3
Revises: 8af56a6ddd78
Create Date: 2019-10-07 16:15:28.196908

"""

# revision identifiers, used by Alembic.
revision = 'bb52cbd644f3'
down_revision = '8af56a6ddd78'

from alembic import op  # noqa: F402
import sqlalchemy as sa  # noqa: F402
from sqlalchemy.sql import select, and_  # noqa: F402
from sqlalchemy import orm  # noqa: F402
from sqlalchemy.dialects import postgresql  # noqa: F402
from sqlalchemy.schema import MetaData  # noqa: F402


def upgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  op.add_column('cloud_streams', sa.Column('preset_id', sa.Integer(), nullable=True))
  op.create_foreign_key(
    'fk_cloud_streams_presets', 'cloud_streams', 'presets', ['preset_id'], ['id'], ondelete='SET NULL')

  bind = op.get_bind()
  session = orm.Session(bind=bind)

  meta = MetaData()
  meta.reflect(bind=bind)

  cloud_streams = meta.tables['cloud_streams']
  preset_cameras = meta.tables['preset_cameras']
  presets = meta.tables['presets']

  for camera in session.execute(cloud_streams.select()):
    preset_id, = session.execute(select([preset_cameras.c.preset_id]).where(
      preset_cameras.c.camera_id == camera.name
    ).limit(1)).fetchone() or (None, )

    if not preset_id:
      preset_id, = session.execute(select([presets.c.id]).where(and_(
        presets.c.is_default.is_(True),
        presets.c.domain_id == camera.domain_id
      )).limit(1)).fetchone() or (None, )

    if preset_id:
      session.execute(
        cloud_streams.update()
        .where(cloud_streams.c.name == camera.name)
        .values(preset_id=preset_id)
      )


def downgrade():
  op.drop_constraint('fk_cloud_streams_presets', 'cloud_streams', type_='foreignkey')
  op.drop_column('cloud_streams', 'preset_id')
