"""streamers_improvements

Revision ID: 75db211c25da
Revises: v19.10
Create Date: 2019-09-18 17:28:17.645409

"""

# revision identifiers, used by Alembic.
revision = '75db211c25da'
down_revision = 'v19.10'

from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm
from sqlalchemy.dialects import postgresql
from sqlalchemy.schema import MetaData


def upgrade():
  op.add_column('streamers', sa.Column('api_url', sa.String(), nullable=True))
  op.add_column('streamers', sa.Column('public_url', sa.String(), nullable=True))
  op.add_column('streamers', sa.Column('provision_required', sa.Boolean(), server_default=sa.sql.false(), nullable=False))
  op.add_column('cloud_streams', sa.Column('streamer_id', sa.Integer(), nullable=True))

  op.create_foreign_key('fk_cloud_streams_streamers', 'cloud_streams', 'streamers', ['streamer_id'], ['id'], ondelete='SET NULL')

  bind = op.get_bind()
  session = orm.Session(bind=bind)

  meta = MetaData()
  meta.reflect(bind=bind)

  cloud_streams = meta.tables['cloud_streams']
  streamers = meta.tables['streamers']

  for streamer in session.execute(streamers.select()):
    api_url = f'http://{streamer.host}:{streamer.port}'

    session.execute(
      cloud_streams.update()
      .where(cloud_streams.c.server == streamer.host)
      .values(streamer_id=streamer.id)
    )
    session.execute(
      streamers.update()
      .where(streamers.c.id == streamer.id)
      .values(api_url=api_url)
    )


def downgrade():
  op.drop_constraint('fk_cloud_streams_streamers', 'cloud_streams', type_='foreignkey')
  op.drop_column('cloud_streams', 'streamer_id')
  op.drop_column('streamers', 'public_url')
  op.drop_column('streamers', 'api_url')
  op.drop_column('streamers', 'provision_required')
