"""fix_other_admins_rights

Revision ID: ecefe294d46f
Revises: 30d629434712
Create Date: 2019-07-29 17:27:16.433798

"""

# revision identifiers, used by Alembic.
revision = 'ecefe294d46f'
down_revision = '30d629434712'

from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm
from sqlalchemy.dialects import postgresql
from watcher.models import (
  OrganizationUser, Domain, CloudStream, User, Organization, Folder, FolderUser
)
from sqlalchemy.orm.attributes import flag_modified


def upgrade():
  #  give other_admins rights in default organization
  bind = op.get_bind()
  session = orm.Session(bind=bind)

  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  domains = meta.tables['domains']
  users = meta.tables['users']
  organization_users = meta.tables['organization_users']

  main_admin = session.query(User.id).filter(
    User.is_admin.is_(True), User.enabled.is_(True)
  ).order_by(User.id).first()

  if main_admin:
    other_admins = session.query(User.id, User.permissions).filter(
      User.is_admin.is_(True), User.enabled.is_(True), User.id != main_admin.id
    ).all()
  else:
    other_admins = []

  default_domain = session.query(Domain.id, Domain.owner_id, Domain.settings).filter(Domain.is_default.is_(True)).first()
  if not default_domain.owner_id and main_admin:
    session.execute(
      domains.update().where(domains.c.id==default_domain.id).values(owner_id=main_admin.id)
    )

  default_organization = session.query(Organization.id).filter(
    Organization.id == default_domain.settings['default_organization_id']
  ).first()

  if default_organization and other_admins:
    for other_admin in other_admins:

      org_user = session.execute(sa.select([organization_users.c.id]).where(
        sa.and_(
          organization_users.c.organization_id==default_organization.id,
          organization_users.c.user_id==other_admin.id
        )
      )).fetchone()
    
      if org_user:
       pass
      else:
        session.execute(
          organization_users.insert().values(
            organization_id=default_organization.id,
            user_id=other_admin.id,
            is_owner=False,
            order_num=0,
          )
        )
      other_admin_permissions = other_admin.permissions or {}
      other_admin_permissions[f'can_edit_organization_cameras_{default_organization.id}'] = True
      other_admin_permissions[f'can_edit_organization_users_{default_organization.id}'] = True
      other_admin_permissions[f'can_view_organization_stats_{default_organization.id}'] = True
      session.execute(
        users.update().where(users.c.id==other_admin.id).values(permissions=other_admin_permissions)
      )
  session.commit()


def downgrade():
  pass
