"""add_default_folder

Revision ID: a0643e0e2993
Revises: 7153563c6767
Create Date: 2019-07-01 20:27:14.851237

"""

# revision identifiers, used by Alembic.
revision = 'a0643e0e2993'
down_revision = '7153563c6767'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy import orm
from sqlalchemy import select
from sqlalchemy.sql import func
from sqlalchemy.orm.attributes import flag_modified
from sqlalchemy.schema import MetaData


def upgrade():
  bind = op.get_bind()
  session = orm.Session(bind=bind)
  from watcher.models import Folder, FolderUser, Organization, CloudStream

  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  cloud_streams = meta.tables['cloud_streams'] 
  organizations = meta.tables['organizations']
  folders = meta.tables['folders']
  folder_users = meta.tables['folder_users']

  session.execute(cloud_streams.update().values(folder_id=None))
  session.execute(folder_users.delete())
  session.execute(folders.delete())

  for organization in session.execute(organizations.select()):
    tree_id = session.scalar(
      select([func.max(folders.c.tree_id) + 1])
    ) or 1

    folder = {
      'title': 'Cameras',
      'domain_id': organization.domain_id,
      'organization_id': organization.id,
      'parent_id': None,
      'level': 1,
      'lft': 1,
      'rgt': 2,
      'tree_id': tree_id
    }

    res = session.execute(folders.insert().values(folder))
    folder_id = res.inserted_primary_key[0]

    session.execute(
      cloud_streams.update()
      .where(cloud_streams.c.organization_id == organization.id)
      .values(folder_id=folder_id)
    )

  session.commit()


def downgrade():
    pass