"""drop preset uniq index

Revision ID: f1ad71f16cd5
Revises: 398e49f54de9
Create Date: 2019-05-22 12:48:55.696706

"""

# revision identifiers, used by Alembic.
revision = 'f1ad71f16cd5'
down_revision = '398e49f54de9'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


def upgrade():
  op.drop_index(op.f('idx_adjustable_default'), table_name='presets')

def downgrade():
  from watcher.models import Preset, OrganizationPreset
  bind = op.get_bind()
  session = sa.orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  presets_table = meta.tables['presets']
  organization_presets_table = meta.tables['organization_presets']

  # remove duplicates that will not allow us to create index again

  duplicates_attrs = session.query(
    Preset.is_adjustable, Preset.is_default, Preset.domain_id, sa.func.count(Preset.id)
  ).group_by(
    Preset.is_adjustable, Preset.is_default, Preset.domain_id
  ).having(sa.func.count(Preset.id) > 1)

  for (is_adjustable, is_default, domain_id, count) in duplicates_attrs:
    duplicates = session.query(Preset.id).filter_by(
      is_adjustable=is_adjustable, is_default=is_default, domain_id=domain_id
    )[1:]
    for preset in duplicates:
      session.execute(
        organization_presets_table.delete().where(
          organization_presets_table.c.preset_id == preset.id
        )
      )
      session.execute(
        presets_table.delete().where(
          presets_table.c.id == preset.id
        )
      )

  session.commit()

  op.create_index(op.f('idx_adjustable_default'), 'presets', ['is_adjustable', 'is_default', 'domain_id'], unique=True)
