"""remove_user_organization_fk

Revision ID: 85534d45a2e2
Revises: df9b50d919e2
Create Date: 2019-05-16 08:39:07.610129

"""

# revision identifiers, used by Alembic.
revision = '85534d45a2e2'
down_revision = 'df9b50d919e2'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
  op.drop_constraint('organizations_owner_id_fkey', 'organizations', type_='foreignkey')
  op.drop_column('organizations', 'owner_id')
  op.drop_constraint('users_organization_fkey', 'users', type_='foreignkey')
  op.drop_column('users', 'organization_id')


def downgrade():
  op.add_column('users', sa.Column('organization_id', sa.INTEGER(), autoincrement=False, nullable=True))
  op.create_foreign_key('users_organization_fkey', 'users', 'organizations', ['organization_id'], ['id'], ondelete='SET NULL')
  op.add_column('organizations', sa.Column('owner_id', sa.INTEGER(), autoincrement=False, nullable=True))
  op.create_foreign_key('organizations_owner_id_fkey', 'organizations', 'users', ['owner_id'], ['id'], ondelete='SET NULL')
