"""organizations_users_m2m

Revision ID: df9b50d919e2
Revises: e0ffbf0a8b28
Create Date: 2019-05-16 08:16:23.347964

"""

# revision identifiers, used by Alembic.
revision = 'df9b50d919e2'
down_revision = 'e0ffbf0a8b28'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy import orm


def upgrade():
  # ### commands auto generated by Alembic - please adjust! ###
  op.create_table('organization_users',
  sa.Column('id', sa.Integer(), nullable=False),
  sa.Column('user_id', sa.Integer(), nullable=False),
  sa.Column('organization_id', sa.Integer(), nullable=False),
  sa.Column('is_owner', sa.Boolean(), nullable=False),
  sa.Column('order_num', sa.Integer(), nullable=False),
  sa.ForeignKeyConstraint(['organization_id'], ['organizations.id'], ),
  sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
  sa.PrimaryKeyConstraint('id'),
  sqlite_autoincrement=True
  )
  op.create_index('organization_user', 'organization_users', ['user_id', 'organization_id'], unique=True)
  
  from watcher.models import User, Organization, OrganizationUser, Domain, StoredFile

  bind = op.get_bind()
  session = orm.Session(bind=bind)
  meta = sa.schema.MetaData()
  meta.reflect(bind=bind)

  users = meta.tables['users'] 
  organizations = meta.tables['organizations']
  organization_users = meta.tables['organization_users']
  stored_files = meta.tables['stored_files']

  org_users = []

  for org in session.execute(organizations.select()):
    for i, user in enumerate(session.execute(users.select().where(users.c.organization_id==org.id))):
      org_users.append({
        'organization_id': org.id,
        'user_id': user.id,
        'is_owner': org.owner_id==user.id,
        'order_num': i + 1,
      })
  
  if org_users:
    session.execute(organization_users.insert(), org_users)
  
  # 
  default_domain = session.query(Domain.id).filter(Domain.is_default.is_(True)).first()

  for sf in session.query(StoredFile.path).all():
    oldpath = sf.path
    newpath = "{0}-{1}".format(default_domain.id, sf.path)
    session.execute(
      stored_files.update().values(path=newpath).where(stored_files.c.path == oldpath)
    )
  session.commit()

def downgrade():
  op.drop_index('organization_user', table_name='organization_users')
  op.drop_table('organization_users')
