"""agent activation tokens

Revision ID: f979ef8c0f9b
Revises: a9aec64ab203
Create Date: 2019-05-16 01:41:45.104901

"""

# revision identifiers, used by Alembic.
revision = 'f979ef8c0f9b'
down_revision = 'a9aec64ab203'

from alembic import op
import sqlalchemy as sa


def upgrade():
  op.create_table('agent_activation_tokens',
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('valid_till', sa.Integer(), nullable=True),
    sa.Column('camera_data', sa.JSON(), nullable=True),
    sa.Column('camera_name', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
  )


def downgrade():
  op.drop_table('agent_activation_tokens')
