"""add default preset to default domain

Revision ID: 43e819895c31
Revises: 0c91c4a29242
Create Date: 2019-04-10 16:20:45.739966

"""

# revision identifiers, used by Alembic.
revision = '43e819895c31'
down_revision = '0c91c4a29242'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from sqlalchemy import orm
from sqlalchemy.schema import MetaData
from sqlalchemy.sql import select, and_  # noqa: F402

def upgrade():
  bind = op.get_bind()
  session = orm.Session(bind=bind)
  from watcher.models import Domain, Preset

  meta = MetaData()
  meta.reflect(bind=bind)

  domains = meta.tables['domains']
  presets = meta.tables['presets']

  default_domain_id, = session.execute(
    select([domains.c.id])
    .where(domains.c.is_default.is_(True))
    .limit(1)
  ).fetchone() or (None, )

  default_preset_id, = session.execute(
    select([presets.c.id])
    .where(and_(
      presets.c.is_default.is_(True),
      presets.c.domain_id == default_domain_id,
    ))
    .limit(1)
  ).fetchone() or (None, )

  if not default_preset_id:
    session.execute(presets.insert().values({
      presets.c.title: 'Default preset',
      presets.c.domain_id: default_domain_id,
      presets.c.is_default: True,
      presets.c.is_adjustable: True,
      presets.c.is_deleted: False
    }))

  session.commit()


def downgrade():
  pass
