from __future__ import with_statement
import warnings
from watcher.alchemy import db
from flask import current_app
from alembic import context
import sqlalchemy as sa
from sqlalchemy import engine_from_config, pool
from logging.config import fileConfig

# this is the Alembic Config object, which provides
# access to the values within the .ini file in use.
config = context.config

# Interpret the config file for Python logging.
# This line sets up loggers basically.
fileConfig(config.config_file_name)

# add your model's MetaData object here
# for 'autogenerate' support
# from myapp import mymodel
# target_metadata = mymodel.Base.metadata
config.set_main_option('sqlalchemy.url', current_app.config.get('SQLALCHEMY_DATABASE_URI'))
target_metadata = db.Model.metadata
# other values from the config, defined by the needs of env.py,
# can be acquired:
# my_important_option = config.get_main_option("my_important_option")
# ... etc.


exclude_tables = [
    'streams', 'located_cameras', 'servers', 'sqlite_sequence', 'endpoint_agents',
    'streampoint_agents', 'warnings', 'temp_tokens', 'fl_motion_event',
    'watcher_notification_queue', 'kombu_message', 'kombu_queue',
]


def include_object(object, name, type_, reflected, compare_to):
  if type_ == "table" and name in exclude_tables:
    return False
  else:
    return True


def run_migrations_offline():
  """Run migrations in 'offline' mode.

  This configures the context with just a URL
  and not an Engine, though an Engine is acceptable
  here as well.  By skipping the Engine creation
  we don't even need a DBAPI to be available.

  Calls to context.execute() here emit the given string to the
  script output.

  """
  url = config.get_main_option("sqlalchemy.url")
  context.configure(url=url, compare_type=True, transaction_per_migration=True)

  with context.begin_transaction():
    context.run_migrations()


def run_migrations_online():
  """Run migrations in 'online' mode.

  In this scenario we need to create an Engine
  and associate a connection with the context.

  """

  engine = engine_from_config(config.get_section(config.config_ini_section),
                              prefix='sqlalchemy.',
                              poolclass=pool.NullPool)

  connection = engine.connect()
  connection.execute('drop table if exists _alembic_batch_temp')
  # for table in exclude_tables:
  #     target_metadata.tables[table].create(engine, checkfirst=True)

  context.configure(connection=connection,
                    include_object=include_object,
                    target_metadata=target_metadata,
                    transaction_per_migration=True,
                    compare_type=True,
                    **current_app.extensions['migrate'].configure_args)

  try:
    with warnings.catch_warnings():
      warnings.simplefilter("ignore", category=sa.exc.SAWarning)
      with context.begin_transaction():
        context.run_migrations()
  finally:
    connection.close()


if context.is_offline_mode():
  run_migrations_offline()
else:
  run_migrations_online()
