"""fix streams

Revision ID: d73b9162f688
Revises: eae667dd68b3
Create Date: 2022-11-24 15:54:35.788003

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'd73b9162f688'
down_revision = 'eae667dd68b3'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_core_streams_current_streamer_hostname', table_name='core_streams')
    op.drop_constraint('core_streams_current_streamer_hostname_fkey', 'core_streams', type_='foreignkey')
    op.drop_column('core_streams', 'current_streamer_hostname')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('core_streams', sa.Column('current_streamer_hostname', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.create_foreign_key('core_streams_current_streamer_hostname_fkey', 'core_streams', 'core_streamers', ['current_streamer_hostname'], ['hostname'], ondelete='SET NULL')
    op.create_index('ix_core_streams_current_streamer_hostname', 'core_streams', ['current_streamer_hostname'], unique=False)