"""fix streams

Revision ID: eae667dd68b3
Revises: 9abb432952fd
Create Date: 2022-11-24 10:40:09.222493

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'eae667dd68b3'
down_revision = '9abb432952fd'
branch_labels = None
depends_on = None


def upgrade():
    # op.add_column('core_streams', sa.Column('id', sa.Integer(), nullable=False))
    op.execute('ALTER TABLE core_streams DROP CONSTRAINT core_streams_pkey CASCADE')
    op.execute('alter table core_streams add id serial')
    op.create_primary_key('core_streams_pkey', 'core_streams', ['id'])
    op.create_unique_constraint('streamer_hostname_name_uc', 'core_streams', ['streamer_hostname', 'name'])
    op.add_column('core_streams', sa.Column('is_refugee', sa.Boolean(), server_default=sa.text('false'), nullable=False))
    op.add_column('core_streams', sa.Column('is_residual', sa.Boolean(), server_default=sa.text('false'), nullable=False))
    op.create_index('core_streams_only_one_non_refugee_non_residual', 'core_streams', ['name', 'is_refugee', 'is_residual'], unique=True, postgresql_where=sa.text('is_refugee IS false AND is_residual IS false'))
    op.add_column('core_streams', sa.Column('created_at_ts', sa.BigInteger(), server_default=sa.text('floor(EXTRACT(epoch FROM now()))'), nullable=False))


def downgrade():

    bind = op.get_bind()
    session = sa.orm.Session(bind=bind)

    from watcher_core.models.stream import Stream
    
    session.query(Stream.__table__).filter(Stream.is_residual == True).delete()
    session.query(Stream.__table__).filter(Stream.is_refugee == True).delete()


    duplicates_streams = session.query(
        Stream.name, sa.func.count(Stream.id)
    ).group_by(
        Stream.name
    ).having(sa.func.count(Stream.id) > 1)
    
    # import pdb; pdb.set_trace()
    streams_to_delete_ids = []
    for (stream_name, count) in duplicates_streams:
        duplicates = session.query(Stream.id).filter_by(
            name=stream_name
        ).order_by(Stream.id)[1:]
        for duplicate_stream in duplicates:
            streams_to_delete_ids.append(duplicate_stream.id)

    session.query(Stream.__table__).filter(Stream.id.in_(streams_to_delete_ids)).delete()

    op.drop_index('core_streams_only_one_non_refugee_non_residual', table_name='core_streams', postgresql_where=sa.text('is_refugee IS false AND is_residual IS false'))
    op.drop_column('core_streams', 'is_residual')
    op.drop_column('core_streams', 'is_refugee')
    op.drop_constraint('streamer_hostname_name_uc', 'core_streams', type_='unique')
    op.execute('ALTER TABLE core_streams DROP CONSTRAINT core_streams_pkey CASCADE')
    op.create_primary_key('core_streams_pkey', 'core_streams', ['name'])
    op.drop_column('core_streams', 'id')
    op.drop_column('core_streams', 'created_at_ts')