"""remove temp stream residence

Revision ID: 9abb432952fd
Revises: 1d2e81b0f370
Create Date: 2022-11-24 10:34:33.907512

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '9abb432952fd'
down_revision = '1d2e81b0f370'
branch_labels = None
depends_on = None


def upgrade():
    op.drop_index('ix_core_stream_temp_residences_stream_name', table_name='core_stream_temp_residences')
    op.drop_index('ix_core_stream_temp_residences_streamer_hostname', table_name='core_stream_temp_residences')
    op.drop_table('core_stream_temp_residences')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_stream_temp_residences',
    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('stream_name', sa.VARCHAR(), autoincrement=False, nullable=False),
    sa.Column('streamer_hostname', sa.VARCHAR(), autoincrement=False, nullable=False),
    sa.Column('start_at', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('end_at', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('cleansed', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['stream_name'], ['core_streams.name'], name='core_stream_temp_residences_stream_name_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['streamer_hostname'], ['core_streamers.hostname'], name='core_stream_temp_residences_streamer_hostname_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='core_stream_temp_residences_pkey')
    )
    op.create_index('ix_core_stream_temp_residences_streamer_hostname', 'core_stream_temp_residences', ['streamer_hostname'], unique=False)
    op.create_index('ix_core_stream_temp_residences_stream_name', 'core_stream_temp_residences', ['stream_name'], unique=False)
