"""add_streampoint

Revision ID: 058a3c66de3e
Revises: 4b92311e2404
Create Date: 2022-08-08 14:34:47.653920

"""
from alembic import op
import sqlalchemy as sa
from watcher_core import utils

# revision identifiers, used by Alembic.
revision = '058a3c66de3e'
down_revision = '4b92311e2404'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('core_streamers', sa.Column('streampoint_key', sa.String(), nullable=True))
    op.add_column('core_streamers', sa.Column('code', sa.String(length=36), nullable=True))

    bind = op.get_bind()
    session = sa.orm.Session(bind=bind)

    core_streamers = sa.Table(
      'core_streamers',
      sa.MetaData(),
      sa.Column('hostname', sa.String(), primary_key=True, nullable=False),
      sa.Column('streampoint_key', sa.String(), nullable=True),
      sa.Column('code', sa.String(length=36), nullable=True),
    )

    streampoint_key = utils.rand_str(10)
    for streamer in session.execute(core_streamers.select()):
      code = utils.uuid4()
      session.execute(
        core_streamers.update()
        .where(core_streamers.c.hostname == streamer.hostname)
        .values(code=code, streampoint_key=streampoint_key)
      )

    session.commit()

    op.alter_column(
      'core_streamers', 'code',
      existing_type=sa.VARCHAR(length=36),
      nullable=False)

    op.alter_column(
      'core_streamers', 'streampoint_key',
      existing_type=sa.String(),
      nullable=False)

    op.create_unique_constraint('core_streamers_code_uc', 'core_streamers', ['code'])


def downgrade():
    op.drop_constraint('core_streamers_code_uc', 'core_streamers', type_='unique')
    op.drop_column('core_streamers', 'streampoint_key')
    op.drop_column('core_streamers', 'code')
