"""agent_stats

Revision ID: 669a941b71e7
Revises: c488984c7eaf
Create Date: 2022-08-02 14:51:44.480678

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '669a941b71e7'
down_revision = 'c488984c7eaf'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('core_agents_stats')
    op.add_column(
      'core_agents',
      sa.Column('endpoint_connection', postgresql.JSONB(none_as_null=True, astext_type=sa.Text()), nullable=True))
    op.add_column(
      'core_agents',
      sa.Column('endpoint_connection_updated_at_ts', sa.BigInteger(), nullable=True))
    op.add_column(
      'core_agents',
      sa.Column('streampoint_connection', postgresql.JSONB(none_as_null=True, astext_type=sa.Text()), nullable=True))
    op.add_column(
      'core_agents',
      sa.Column('streampoint_connection_updated_at_ts', sa.BigInteger(), nullable=True))
    op.drop_index('ix_core_agents_streamer_hostname', table_name='core_agents')
    op.drop_constraint('core_agents_streamer_hostname_fkey', 'core_agents', type_='foreignkey')
    op.drop_column('core_agents', 'streamer_hostname')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('core_agents', sa.Column('streamer_hostname', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.create_foreign_key(
      'core_agents_streamer_hostname_fkey', 'core_agents', 'core_streamers',
      ['streamer_hostname'], ['hostname'], ondelete='SET NULL'
    )
    op.create_index('ix_core_agents_streamer_hostname', 'core_agents', ['streamer_hostname'], unique=False)
    op.drop_column('core_agents', 'streampoint_connection_updated_at_ts')
    op.drop_column('core_agents', 'streampoint_connection')
    op.drop_column('core_agents', 'endpoint_connection_updated_at_ts')
    op.drop_column('core_agents', 'endpoint_connection')
    op.create_table(
      'core_agents_stats',
      sa.Column('agent_id', sa.VARCHAR(), autoincrement=False, nullable=False),
      sa.Column(
        'agent_type', sa.VARCHAR(),
        server_default=sa.text("'single'::character varying"),
        autoincrement=False, nullable=True
      ),
      sa.Column('connections_requested', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
      sa.Column(
        'connections_established', sa.INTEGER(), server_default=sa.text('0'),
        autoincrement=False, nullable=True
      ),
      sa.Column('serial', sa.VARCHAR(), autoincrement=False, nullable=True),
      sa.Column('peer_ip', sa.VARCHAR(), autoincrement=False, nullable=True),
      sa.Column('local_ip', sa.VARCHAR(), autoincrement=False, nullable=True),
      sa.Column('mac_address', sa.VARCHAR(), autoincrement=False, nullable=True),
      sa.Column('version', sa.VARCHAR(), autoincrement=False, nullable=True),
      sa.Column('endpoint_connection', postgresql.JSONB(astext_type=sa.Text()), autoincrement=False, nullable=True),
      sa.Column('streampoint_connection', postgresql.JSONB(astext_type=sa.Text()), autoincrement=False, nullable=True),
      sa.ForeignKeyConstraint(['agent_id'], ['core_agents.id'], name='core_agents_stats_agent_id_fkey'),
      sa.PrimaryKeyConstraint('agent_id', name='core_agents_stats_pkey')
    )
    # ### end Alembic commands ###
