"""alter streamer schema

Revision ID: c488984c7eaf
Revises: f30151a911bc
Create Date: 2022-07-13 17:40:14.693083

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'c488984c7eaf'
down_revision = 'f30151a911bc'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('core_streamers', sa.Column('channel_limit', sa.BigInteger(), nullable=True))
    op.add_column('core_streamers', sa.Column('cpu_limit', sa.BigInteger(), nullable=True))
    op.add_column(
      'core_streamers',
      sa.Column('dvr', postgresql.JSONB(none_as_null=True, astext_type=sa.Text()), nullable=True)
    )
    op.add_column('core_streamers', sa.Column('fetch_timeout', sa.BigInteger(), nullable=True))
    op.add_column('core_streamers', sa.Column('max_bitrate', sa.BigInteger(), nullable=True))
    op.add_column('core_streamers', sa.Column('private_payload_url', sa.String(), nullable=True))
    op.add_column('core_streamers', sa.Column('public_payload_url', sa.String(), nullable=True))
    op.add_column('core_streamers', sa.Column('stale_timeout', sa.BigInteger(), nullable=True))
    op.drop_column('core_streamers', 'capacity')
    op.drop_column('core_streamers', 'public_url')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('core_streamers', sa.Column('public_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column(
      'core_streamers',
      sa.Column('capacity', postgresql.JSONB(astext_type=sa.Text()), autoincrement=False, nullable=True)
    )
    op.drop_column('core_streamers', 'stale_timeout')
    op.drop_column('core_streamers', 'public_payload_url')
    op.drop_column('core_streamers', 'private_payload_url')
    op.drop_column('core_streamers', 'max_bitrate')
    op.drop_column('core_streamers', 'fetch_timeout')
    op.drop_column('core_streamers', 'dvr')
    op.drop_column('core_streamers', 'cpu_limit')
    op.drop_column('core_streamers', 'channel_limit')
    # ### end Alembic commands ###
