"""add_temp_stream_residence

Revision ID: f30151a911bc
Revises: 26ed85d54b8b
Create Date: 2022-07-02 18:19:47.766423

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f30151a911bc'
down_revision = '26ed85d54b8b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
      'core_stream_temp_residences',
      sa.Column('id', sa.Integer(), nullable=False),
      sa.Column('stream_name', sa.String(), nullable=False),
      sa.Column('streamer_hostname', sa.String(), nullable=False),
      sa.Column('start_at', sa.DateTime(), nullable=False),
      sa.Column('end_at', sa.DateTime(), nullable=True),
      sa.Column('cleansed', sa.Boolean(), nullable=False),
      sa.ForeignKeyConstraint(['stream_name'], ['core_streams.name'], ondelete='CASCADE'),
      sa.ForeignKeyConstraint(['streamer_hostname'], ['core_streamers.hostname'], ondelete='CASCADE'),
      sa.PrimaryKeyConstraint('id')
    )
    op.create_index(
      op.f('ix_core_stream_temp_residences_stream_name'),
      'core_stream_temp_residences',
      ['stream_name'],
      unique=False
    )
    op.create_index(
      op.f('ix_core_stream_temp_residences_streamer_hostname'),
      'core_stream_temp_residences',
      ['streamer_hostname'],
      unique=False
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_core_stream_temp_residences_streamer_hostname'), table_name='core_stream_temp_residences')
    op.drop_index(op.f('ix_core_stream_temp_residences_stream_name'), table_name='core_stream_temp_residences')
    op.drop_table('core_stream_temp_residences')
    # ### end Alembic commands ###
