"""initial

Revision ID: 26ed85d54b8b
Revises:
Create Date: 2022-05-05 19:29:56.990665

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '26ed85d54b8b'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
      'core_config',
      sa.Column('id', sa.Integer(), nullable=False),
      sa.Column('title', sa.String(), nullable=True),
      sa.Column('brand', sa.String(), nullable=True),
      sa.Column('logo', sa.String(), nullable=True),
      sa.Column('logoAuth', sa.String(), nullable=True),
      sa.Column('product', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('fonts', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('favicons', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('menu_items', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('extraMenu', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('debian_package', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.PrimaryKeyConstraint('id')
    )
    op.create_table(
      'core_events',
      sa.Column('event_id', sa.BigInteger(), nullable=False),
      sa.Column('event', sa.String(), nullable=True),
      sa.Column('event_type', sa.String(), nullable=True),
      sa.Column('utc_ms', sa.BigInteger(), nullable=True),
      sa.Column('media', sa.String(), nullable=True),
      sa.Column('submedia', sa.String(), nullable=True),
      sa.Column('face_id', sa.String(), nullable=True),
      sa.Column('plate_number', sa.String(), nullable=True),
      sa.Column('preview', sa.LargeBinary(), nullable=True),
      sa.PrimaryKeyConstraint('event_id')
    )
    op.create_table(
      'core_streamers',
      sa.Column('hostname', sa.String(), nullable=False),
      sa.Column('api_url', sa.String(), nullable=True),
      sa.Column('public_url', sa.String(), nullable=True),
      sa.Column('cluster_key', sa.String(), nullable=True),
      sa.Column('capacity', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('stats', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('provision_required', sa.Boolean(), server_default=sa.text('false'), nullable=False),
      sa.Column('stats_updated_at_ts', sa.BigInteger(), nullable=True),
      sa.PrimaryKeyConstraint('hostname')
    )

    op.create_table(
      'core_agents',
      sa.Column('id', sa.String(), nullable=False),
      sa.Column('key', sa.String(), nullable=True),
      sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
      sa.Column('streamer_hostname', sa.String(), nullable=True),
      sa.ForeignKeyConstraint(['streamer_hostname'], ['core_streamers.hostname'], ondelete='SET NULL'),
      sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_core_agents_deleted_at'), 'core_agents', ['deleted_at'], unique=False)
    op.create_index(op.f('ix_core_agents_streamer_hostname'), 'core_agents', ['streamer_hostname'], unique=False)
    op.create_table(
      'core_streams',
      sa.Column('name', sa.String(), nullable=False),
      sa.Column('title', sa.String(), nullable=True),
      sa.Column('template', sa.String(), nullable=True),
      sa.Column('static', sa.Boolean(), nullable=False),
      sa.Column('inputs', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('thumbnails', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('dvr', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('on_play', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('prepush', sa.Boolean(), nullable=False),
      sa.Column('cluster_ingest', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('vision', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('stats', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('streamer_hostname', sa.String(), nullable=True),
      sa.Column('current_streamer_hostname', sa.String(), nullable=True),
      sa.Column('provision_required', sa.Boolean(), server_default=sa.text('false'), nullable=False),
      sa.ForeignKeyConstraint(['streamer_hostname'], ['core_streamers.hostname'], ondelete='SET NULL'),
      sa.ForeignKeyConstraint(['current_streamer_hostname'], ['core_streamers.hostname'], ondelete='SET NULL'),
      sa.PrimaryKeyConstraint('name')
    )
    op.create_index(op.f('ix_core_streams_streamer_hostname'), 'core_streams', ['streamer_hostname'], unique=False)
    op.create_index(
      op.f('ix_core_streams_current_streamer_hostname'),
      'core_streams',
      ['current_streamer_hostname'],
      unique=False
    )

    op.create_table(
      'core_agents_stats',
      sa.Column('agent_id', sa.String(), nullable=False),
      sa.Column('agent_type', sa.String(), server_default='single', nullable=True),
      sa.Column('connections_requested', sa.Integer(), server_default='0', nullable=True),
      sa.Column('connections_established', sa.Integer(), server_default='0', nullable=True),
      sa.Column('serial', sa.String(), nullable=True),
      sa.Column('peer_ip', sa.String(), nullable=True),
      sa.Column('local_ip', sa.String(), nullable=True),
      sa.Column('mac_address', sa.String(), nullable=True),
      sa.Column('version', sa.String(), nullable=True),
      sa.Column('endpoint_connection', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.Column('streampoint_connection', postgresql.JSONB(astext_type=sa.Text(), none_as_null=True), nullable=True),
      sa.ForeignKeyConstraint(['agent_id'], ['core_agents.id'], ),
      sa.PrimaryKeyConstraint('agent_id')
    )
    bind = op.get_bind()
    session = sa.orm.Session(bind=bind)

    config_table = sa.Table(
      'core_config',
      sa.MetaData(),
      sa.Column('title', sa.String(), nullable=True),
    )

    session.execute(config_table.insert().values({"title": "Watcher"}))
    session.commit()


def downgrade():
  op.drop_table('core_agents_stats')
  op.drop_index(op.f('ix_core_streams_current_streamer_hostname'), table_name='core_streams')
  op.drop_index(op.f('ix_core_streams_streamer_hostname'), table_name='core_streams')
  op.drop_table('core_streams')
  op.drop_index(op.f('ix_core_agents_streamer_hostname'), table_name='core_agents')
  op.drop_index(op.f('ix_core_agents_deleted_at'), table_name='core_agents')
  op.drop_table('core_agents')
  op.drop_table('core_streamers')
  op.drop_table('core_events')
  op.drop_table('core_config')
