from __future__ import with_statement

from logging.config import fileConfig

from sqlalchemy import engine_from_config
from sqlalchemy import pool

from alembic import context

from flask import current_app
from loguru import logger
# this is the Alembic Config object, which provides
# access to the values within the .ini file in use.
config = context.config

# Interpret the config file for Python logging.
# This line sets up loggers basically.
fileConfig(config.config_file_name)

# add your model's MetaData object here
# for 'autogenerate' support
# from myapp import mymodel
# target_metadata = mymodel.Base.metadata

exclude_tables = (
  # don't look at watcher-vms tables
  'alembic_version',
  'device_tokens',
  'license_plates',
  'users',
  'stored_files',
  'session_usages',
  'mosaics',
  'request_entries',
  'agent_activation_tokens',
  'source_events',
  'user_serials',
  'events',
  'camera_streamers',
  'agents',
  'streamers',
  'domains',
  'stream_statuses',
  'activity_persons',
  'activity_cars',
  'organization_presets',
  'organization_users',
  'agent_statuses',
  'person_category',
  'preset_cameras',
  'camera_person_list_association',
  'organizations',
  'deleted_streams',
  'stream_usages',
  'car_list_association',
  'folder_users',
  'watcher_messages',
  'source_events_stats',
  'nvrs',
  'activity_faces',
  'config',
  'disk_usages',
  'folders',
  'log_entries',
  'mosaic_cameras',
  'person_list',
  'event_subscriptions',
  'car_list',
  'cloud_streams',
  'streamer_statuses',
  'watcher_sessions',
  'presets',
  'metrics',
  'locales',
)
config.set_main_option(
    "sqlalchemy.url",
    str(current_app.extensions["migrate"].db.engine.url).replace("%", "%%"),
)
target_metadata = current_app.extensions["migrate"].db.metadata

# other values from the config, defined by the needs of env.py,
# can be acquired:
# my_important_option = config.get_main_option("my_important_option")
# ... etc.


def include_object(object, name, type_, *args, **kwargs):
    table_name = ''
    if type_ == 'table':
        table_name = name
    elif type_ == 'index':
        table_name = object.table.name
    return not (table_name in exclude_tables)


def run_migrations_offline():
    """Run migrations in 'offline' mode.

    This configures the context with just a URL
    and not an Engine, though an Engine is acceptable
    here as well.  By skipping the Engine creation
    we don't even need a DBAPI to be available.

    Calls to context.execute() here emit the given string to the
    script output.

    """
    url = config.get_main_option("sqlalchemy.url")
    context.configure(
      url=url,
      target_metadata=target_metadata,
      literal_binds=True,
      include_object=include_object
    )

    with context.begin_transaction():
        context.run_migrations()


def run_migrations_online():
    """Run migrations in 'online' mode.

    In this scenario we need to create an Engine
    and associate a connection with the context.

    """

    # this callback is used to prevent an auto-migration from being generated
    # when there are no changes to the schema
    # reference: http://alembic.zzzcomputing.com/en/latest/cookbook.html
    def process_revision_directives(context, revision, directives):
        if getattr(config.cmd_opts, "autogenerate", False):
            script = directives[0]
            if script.upgrade_ops.is_empty():
                directives[:] = []
                logger.info("No changes in schema detected.")

    connectable = engine_from_config(
        config.get_section(config.config_ini_section),
        prefix="sqlalchemy.",
        poolclass=pool.NullPool,
    )

    with connectable.connect() as connection:
        context.configure(
            connection=connection,
            target_metadata=target_metadata,
            process_revision_directives=process_revision_directives,
            version_table="core_alembic_version",
            include_object=include_object,
            **current_app.extensions["migrate"].configure_args
        )

        with context.begin_transaction():
            context.run_migrations()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
