-include_lib("corelib/include/corelib_openapi.hrl").
-ifdef(MEDIA_INFO_HRL).
-error(already_included_media_info_hrl).
-else.
-define(MEDIA_INFO_HRL,true).
-endif.


-type deprecated(X) :: X.
-type wrong_typed(X) :: X.


-type binary_int() :: binary().  % То, что должно парситься в инт, но пробрасывается бинарем
-type binary_value() :: binary(). % То, что должно парситься в атом, но отдается бинарем
-type binary_boolean() :: binary().



-define(DEFAULT_FPS, 25).


-type(frame_sound_channels() ::mono|stereo).
-type(frame_sound_size() ::bit8|bit16).
-type(frame_sound_rate() ::rate5|rate11|rate22|rate44).
% -type(frame_sound() ::{frame_sound_channels(), frame_sound_size(), frame_sound_rate()}).



-record(ad_splice, {
  % все таймстемпы в миллисекундах
  id,
  type,
  at,
  out,
  duration,
  scte35,
  time_shift = 0,
  elapsed,
  in,
  cont,
  auto_return
}).

-type ad_splice() :: #ad_splice{
  id :: integer(),
  type :: splice_insert | private_command,
  at :: ticks(),
  out :: boolean(),
  duration :: integer(),
  scte35 :: binary(),
  time_shift :: non_neg_integer(),
  elapsed :: integer(),
  in :: before_out | after_out,
  cont :: boolean(),
  auto_return :: boolean()
}.

-record(splicing, {
  splice,
  announces = []
}).

-type splicing() :: #splicing{
  splice :: ad_splice(),
  announces :: [ad_splice()]
}.



-record(video_frame,{
  content,
  dts,
  pts,
  duration,
  stream_id,
  codec,
  flavor,
  track_id,
  body = <<>>,
  next_id,
  mpegts,
  source,
  options = #{},
  splicing
}).


-record(epg_event, {
  stream_id,
  source,
  id, % event_id
  start, % start_time
  duration, % duration
  status, % running_status
  language, % short_event_descriptor.language
  name, % short_event_descriptor.event_name
  about, % short_event_descriptor.text
  encrypted, % free_CA_mode
  rating, % parental_rating_descriptor decoded
  genre, % content_descriptior decoded
  ext % extended_event_descriptor decoded :: [{lang,Lang::binary()},{text,Text::binary()}]
}).


% RTP bases its timestamp on NTP. NTP counts from 1900. Shift it to 1970. This constant is not precise.
% 2208988800 =  calendar:datetime_to_gregorian_seconds({{1970,1,1}, {0,0,0}}) - calendar:datetime_to_gregorian_seconds({{1900,1,1}, {0,0,0}}).
-define(NTP_EPOCH_DELTA, 2208988800).

-define(FIRST_JAN_2018, 1514764800).

-define(DTS_IS_US,false).

-define(MIN_SECOND,1000000000).
-define(MAX_SECOND,2000000000).
-define(MIN_MILLI_SECOND, 1000000000000).
-define(MAX_MILLI_SECOND, 2000000000000).
-define(MIN_MICRO_SECOND, 1000000000000000).
-define(MAX_MICRO_SECOND, 2000000000000000).

-define(TIMEBASE_MS, 1000).
-define(TIMEBASE_90KHZ, 90000).


-if(?DTS_IS_US).
% Микросекунды
-define(TICKS_IN_MS, 1000).
-define(TICKS_WORD, "us").
-define(NOW_TICKS(), minute:now_us()).
-define(KHZ90_TO_TICKS(X), (((X)*1000) div 90)).
-define(TICKS_TO_KHZ90(X), (((X)*90) div 1000)). % *90/1000 = *0.09 = /11
-define(TICKS_TO_MHZ27(X), ((X)*27)).
-define(TICKS_TO_SEC(X), ((X) div 1000000)).
-define(TICKS_TO_MS(X), ((X) div 1000)).
-define(TICKS_TO_US(X), (X)).
-define(SEC_TO_TICKS(X), round((X)*1000000)).
-define(MS_TO_TICKS(X), round((X)*1000)).
-define(US_TO_TICKS(X), (X)).

-define(MIN_TICK, ?MIN_MICRO_SECOND).
-define(MAX_TICK, ?MAX_MICRO_SECOND).

-else.
% Дробные миллисекунды
-define(TICKS_IN_MS, 1).
-define(TICKS_WORD, "ms").
-define(NOW_TICKS(), minute:now_ms()).
-define(KHZ90_TO_TICKS(X), ((X) / 90)).
-define(TICKS_TO_KHZ90(X), round((X)*90)).
-define(TICKS_TO_MHZ27(X), round((X)*27000)).
-define(TICKS_TO_SEC(X), trunc((X)/1000)).
-define(TICKS_TO_MS(X), (X)).
-define(TICKS_TO_US(X), trunc((X)*1000)).
-define(SEC_TO_TICKS(X), ((X)*1000.0)).
-define(MS_TO_TICKS(X), ((X)*1.0)).
-define(US_TO_TICKS(X), ((X)/1000)).

-define(MIN_TICK, (?MIN_MILLI_SECOND)).
-define(MAX_TICK, (?MAX_MILLI_SECOND)).

-endif.



-record(segment,{
  opened_at, % expected to be in seconds
  dts,
  number,
  duration,
  drm_key,
  body,
  jpeg,
  locked = false,
  discontinuity = false,
  skip_storage = false,
  media_info,

  % It's pid of process which create this segment
  source,
  ad,
  ad_extra = [],
  % Where we found this segment
  source_type = ram,
  % Pid of process which requested creating segment
  requester
}).










-define(TRACK_INFO_VIDEO_FIELDS_USER,
  ,nals = [],
  rtsp_control, % where to keep RTSP control field from SDP
  payload_num
).

-define(TRACK_INFO_VIDEO_FIELDS_SPEC_USER,
  ,nals   :: [binary()],
  rtsp_control :: binary() | undefined,
  payload_num :: integer() | undefined
).

-define(TRACK_INFO_AUDIO_FIELDS_USER,
  ,sample_fmt, %  = <<"fltp">>
  channel_layout,
  samples = 0,
  parsed_config
).

-define(TRACK_INFO_AUDIO_FIELDS_SPEC_USER,
  ,sample_fmt :: binary_value() | undefined, %  = <<"fltp">>
  channel_layout :: binary_value() | undefined,
  samples ::non_neg_integer() | undefined
).


-define(TRACK_INFO_FIELDS_USER,
  ,orig_track_id,
  config,
  timescale = 90, % How many timestamp units are in one millisecond for this track
  drm_key, %% требуется только для вызова mp4_writer
  options = []
).

-define(TRACK_INFO_FIELDS_SPEC_USER,
  ,orig_track_id ::non_neg_integer() | undefined,
  config :: binary() | undefined,
  timescale :: number()|undefined, % How many timestamp units are in one millisecond for this track
  drm_key ::any(), %% требуется только для вызова mp4_writer
  options ::proplists:proplist()
).


-define(MEDIA_INFO_FIELDS_USER,
  ,source,
  options = []
).

-define(MEDIA_INFO_FIELDS_SPEC_USER,
  ,source :: any(),
  options :: proplists:proplist()
).


-define(DEFAULT_BUFFER_LENGTH, 60). % параметр mpegts_output_buffer


-include("media_info_types.hrl").


-include("media_info_openapi.hrl").


%%% codecs
%%% This defines are used to make implementing a new codec easier.

-define(IS_AV_CODEC(C),   (?IS_VIDEO_CODEC(C) orelse ?IS_AUDIO_CODEC(C))).
% -define(IS_AVT_CODEC(C),  (?IS_VIDEO_CODEC(C) orelse ?IS_AUDIO_CODEC(C) orelse (?IS_TEXT_CODEC(C) andalso C =/= scte35))).
% -define(IS_AVTC_CODEC(C), (?IS_AVT_CODEC(C) orelse C == scte35).

-define(IS_MPEGTS_AUDIO_CODEC(C), (?IS_AUDIO_CODEC(C) andalso C =/= pcma andalso C =/= pcmu)).
-define(IS_MPEGTS_TEXT_CODEC(C),  (C == ttxt orelse C == subtitle)).
-define(IS_MPEGTS_AV_CODEC(C),    (?IS_MPEGTS_AUDIO_CODEC(C) orelse ?IS_VIDEO_CODEC(C))).
-define(IS_MPEGTS_AVT_CODEC(C),   (?IS_MPEGTS_AV_CODEC(C) orelse ?IS_MPEGTS_TEXT_CODEC(C))).
-define(IS_MPEGTS_AVTC_CODEC(C),  (?IS_MPEGTS_AVT_CODEC(C) orelse (C == scte35) orelse (C == scte27))).

-define(IS_HLS_AVT_CODEC(C), (?IS_VIDEO_CODEC(C) orelse ?IS_TEXT_CODEC(C) orelse
    (C == aac orelse C == mp3 orelse C == mp2a orelse C == ac3 orelse C == eac3) orelse
    (C == mpegts))).

-define(IS_MP4_AV_CODEC(C), (C == h264 orelse C == hevc orelse C == mp2v orelse
    C == av1 orelse
    C == aac orelse C == mp3 orelse C == mp2a orelse C == ac3 orelse C == eac3 orelse C == opus)).

-define(IS_RTSP_AV_CODEC(C), (C == h264 orelse C == hevc orelse C == aac orelse C == mp3 orelse C == pcma orelse C == pcmu
    orelse C == opus
    orelse C == av1
    orelse C == mpegts orelse C == onvif orelse C == mp2a orelse C == jpeg)).

-define(IS_FLV_VIDEO_CODEC(C), (C == screen)).

-define(IS_WEBRTC_AUDIO_CODEC(C), (C == pcma orelse C == pcmu orelse C == opus)).
-define(IS_WEBRTC_VIDEO_CODEC(C), (C == av1 orelse C == h264 orelse C == vp8 orelse C == vp9)).
-define(IS_WEBRTC_AV_CODEC(C), (?IS_WEBRTC_AUDIO_CODEC(C) orelse ?IS_WEBRTC_VIDEO_CODEC(C))).


-define(IS_RTMP_AUDIO_CODEC(C), (C == pcma orelse C == pcmu orelse C == aac orelse C == mp3)).
-define(IS_RTMP_VIDEO_CODEC(C), (C == h264)).
-define(IS_RTMP_AV_CODEC(C), (?IS_RTMP_AUDIO_CODEC(C) orelse ?IS_RTMP_VIDEO_CODEC(C) orelse C == metadata)).
%%% end codecs


% % название stream_event вызвало некоторое непонимание
% % на момент его появления оно сигнализировало о некоторых событиях только в источнике
% % был вариант source_event, но пока решили оставить так
% -record(stream_event, {
%   stream_id   :: binary(),              % имя стрима
%   source      :: pid(),                 % pid процесса источника в котором возник event
%   timestamp   :: ticks(),               % now_ms, в который был сгенерирован эвент
%   pid         :: pid(),                 % pid процесса, в котором был сгенерирован эвент
%   event       :: decoder_reset,         % Название эвента
%   meta = #{}  :: #{atom() => any()}  % та же мета, что передаётся в эвент"
% }).



% пока не придумал лучше названия, пусть оно будет просто проходить насквозь
-record(media_debug, {
  msg :: any()
}).

-record(media_sequence_jump, {
  track_id :: non_neg_integer(),
  expected :: non_neg_integer(),
  actual :: non_neg_integer()
}).

-record(media_drop_frames, {
  count :: non_neg_integer()
}).

-record(media_decode_error, {
  track :: non_neg_integer()|undefined,
  reason :: atom()
}).

-record(media_decoder_reset, {
  pid :: undefined|non_neg_integer(), % MPEG-TS PID
  timestamp :: undefined|utc_ms(),
  reason :: atom(),
  details = #{} :: #{atom() => any()}
}).

-record(media_connection_report, {
  status :: atom(),
  while :: atom(),
  ip :: binary() | undefined,
  version :: integer() | binary() | undefined, % when we know version of peer
  to :: binary() | undefined % redirect target
}).

% Indicates that upstream has lost its source.
% Is propagated by live_stream when currently used source is lost (but will return later)
-record(media_source_lost, {
  url :: binary()
}).


% The least message from current pid before its death
-record(media_error, {
  reason :: atom(),
  code :: non_neg_integer() | undefined,
  details = #{} :: #{atom() => any()},
  bytes = 0 :: non_neg_integer()
}).

-record(media_source_id, {
  id :: binary()
}).

-record(media_user_agent, {
  ua :: binary()
}).

-record(media_source_hostname, {
  host :: binary()
}).

-record(media_segment_opened, {
  opened_at :: non_neg_integer()
}).

% Для асинхронной доставки по тракту частей #session_counters, чтобы запись их в сессию производил монопольно live_stream
% Изначально сделано для транскодера, дальше при необходимости можно расширять
-record(media_counters, {
  field :: transcoder,
  counters :: any()   %% Тут на самом деле должны быть счётчики из session.hrl, но некрасиво делать media_info.hrl зависимым от сессий
}).

-type media_event() ::
  #media_error{} |
  #media_debug{} |
  #media_sequence_jump{} |
  #media_decode_error{} |
  #media_decoder_reset{} |
  #media_connection_report{} |
  #media_source_id{} |
  #media_source_lost{} |
  #media_user_agent{} |
  #media_source_hostname{} |
  #media_segment_opened{} |
  #media_counters{} |
  #media_drop_frames{}.


-record(media_event, {
  source :: pid() | undefined,
  stream_id :: binary() | undefined,
  e :: media_event()
}).



-record(pusher_connected, {
  ip :: binary() | undefined,
  url :: binary() | undefined
}).

-record(pusher_started, {
}).

-record(pusher_updated, {
  bytes :: non_neg_integer(),  % Общее количетсво байт, накопительным итогом
  retries :: non_neg_integer() | undefined
}).

% Проблема, которую можно обработать, не прерывая поток
-record(pusher_error, {
  reason :: atom(),
  while :: atom()
}).

-record(pusher_closed, {
  reason :: atom(),
  code :: non_neg_integer() | undefined, % other side integer error code
  while :: atom() % Уточнение контекста
}).


-record(pusher_multicast_push_blocked, {
  ip :: binary() | undefined
}).

-record(pusher_multicast_push_restored, {
}).

-type pusher_event() ::
  #pusher_connected{} |
  #pusher_started{} |
  #pusher_updated{} |
  #pusher_error{} |
  #pusher_multicast_push_blocked{} |
  #pusher_multicast_push_restored{} |
  #pusher_closed{}.

-record(pusher_message, {
  source,
  e
}).

% Протокол обратной связи по видеотракту
-type pusher_message() :: #pusher_message{
  source :: pid(),
  e :: pusher_event()
}.



% Это тот протокол, которым обмениваются все компоненты в видеотракте.
% FIXME: сюда надо добавить source_feedback и source_error
-type frame_message() ::
  #media_info{} |
  #video_frame{} |
  #media_event{} |
  #segment{} |
  #epg_event{}.





-define(DEFAULT_PUSHER_FEEDBACK_TIMEOUT, 1000).
