#!/bin/bash


[ -z "$NODE" ] && NODE="chassis@server.l"


export ERL_CRASH_DUMP_SECONDS=0
ERLARGS="-kernel prevent_overlapping_partitions false"
BOOTARGS=""


while [ ! -z "$1" ]; do
  case "$1" in
    "-noinput")
      ERLARGS="$ERLARGS -noinput"
      ;;
    "-h")
      HOME="$2"
      shift
      ;;
    "-l")
      LOGDIR="$2"
      shift
      ;;
    "-d")
      DEBUG="debug"
      ;;
    "-c")
      CONFIG="$2"
      shift
      ;;
    "-dev")
      DEBUG=${DEBUG:-debug}
      LOGDIR=${LOGDIR:-tmp}
      CONFIG=${CONFIG:-tmp/chassis.conf}
      ;;
    "-root")
      FAKE_ROOT="root $2"
      CONFIG="$2/etc/chassis.conf"
      shift
      ;;
    *)
      break
  esac
  shift
done



LOGDIR=${LOGDIR:-/var/log/chassis}
CONFIG=${CONFIG:-/etc/chassis.conf}

export HOME
BOOTARGS="$BOOTARGS log_dir $LOGDIR $DEBUG config $CONFIG $HAL $FAKE_ROOT"


if [ -d _build/prod/opt/flussonic/lib/ ]; then
  export ERL_LIBS=_build/prod/opt/flussonic/lib/
elif [ -d _build/default/lib ]; then
  export ERL_LIBS=_build/default/lib
else
  export PATH=/opt/flussonic/bin:$PATH
  export ERL_LIBS=/opt/flussonic/lib
  if [ -z "$ERLHOME" -a -z "$HOME" ]; then
    HOME=/etc/flussonic
  elif [ -z "$HOME" ]; then
    HOME="$ERLHOME"
  fi
fi

if [ -z ${ERL_INETRC+x} ]; then
  if [ -f /opt/flussonic/.inetrc ]; then
    export ERL_INETRC=/opt/flussonic/.inetrc
  else
    export ERL_INETRC=`pwd`/deploy/packaging/root/opt/flussonic/.inetrc
  fi
fi

exec erl \
    -name $NODE -boot start_sasl -start_epmd false -sasl errlog_type error $ERLARGS \
    -s chassis start_app $BOOTARGS

